/*
 * InputForm.java
 * Create on 2004/03/22
 * Create by tetsuo
 * $Id$
 * Copyright(c)2003-2004 CASAREAL,Inc. All Rights Reserved.
 */
package study.xdoclet.struts.form;

import org.apache.struts.validator.ValidatorForm;

/**
 * InputForm
 * @struts.form
 *  name="inputForm"
 * @author tetsuo
 * 
 */
public class InputForm extends ValidatorForm {

	private String firstName;
	private String lastName;
	private String zipcode;
	private String address;
	private String telno;
	private String email;

	/**
	 * getAddress
	 * @return
	 */
	public String getAddress() {
		return address;
	}

	/**
	 * getEmail
	 * @return
	 */
	public String getEmail() {
		return email;
	}

	/**
	 * getFirstName
	 * @return
	 */
	public String getFirstName() {
		return firstName;
	}

	/**
	 * getLastName
	 * @return
	 */
	public String getLastName() {
		return lastName;
	}

	/**
	 * getTelno
	 * @return
	 */
	public String getTelno() {
		return telno;
	}

	/**
	 * getZipcode
	 * @return
	 */
	public String getZipcode() {
		return zipcode;
	}

	/**
	 * setAddress
	 * @struts.validator
	 *  type="required"
	 * @struts.validator
	 *  type="maxlength"
	 * @struts.validator-var
	 *  name="maxlength"
	 *  value="60"
	 * @struts.validator-args
	 *  arg0resource="inputForm.address"
	 *  arg1value="${var:maxlength}"
	 * @param string
	 */
	public void setAddress(String string) {
		address = string;
	}

	/**
	 * setEmail
	 * @struts.validator
	 *  type="required"
	 * @struts.validator
	 *  type="maxlength"
	 * @struts.validator
	 *  type="email"
	 * @struts.validator-var
	 *  name="maxlength"
	 *  value="60"
	 * @struts.validator-args
	 *  arg0resource="inputForm.email"
	 *  arg1value="${var:maxlength}"
	 * @param string
	 */
	public void setEmail(String string) {
		email = string;
	}

	/**
	 * setFirstName
	 * @struts.validator
	 *  type="required"
	 * @struts.validator
	 *  type="maxlength"
	 * @struts.validator-var
	 *  name="maxlength"
	 *  value="30"
	 * @struts.validator-args
	 *  arg0resource="inputForm.firstName"
	 *  arg1value="${var:maxlength}"
	 * @param string
	 */
	public void setFirstName(String string) {
		firstName = string;
	}

	/**
	 * setLastName
	 * @struts.validator
	 *  type="required"
	 * @struts.validator
	 *  type="maxlength"
	 * @struts.validator-var
	 *  name="maxlength"
	 *  value="30"
	 * @struts.validator-args
	 *  arg0resource="inputForm.lastName"
	 *  arg1value="${var:maxlength}"
	 * @param string
	 */
	public void setLastName(String string) {
		lastName = string;
	}

	/**
	 * setTelno
	 * @struts.validator
	 *  type="required"
	 * @struts.validator
	 *  type="mask"
	 * @struts.validator-var
	 *  name="mask"
	 *  value="^[0][1-9]((\d{2,3}-?)|(-\d{2,3})|(\d-\d{1,2})|(\d{2}-\d))\d-\d{4}$"
	 * @struts.validator-args
	 *  arg0resource="inputForm.telno"
	 * @param string
	 */
	public void setTelno(String string) {
		telno = string;
	}

	/**
	 * setZipcode
	 * @struts.validator
	 *  type="required"
	 * @struts.validator
	 *  type="mask"
	 * @struts.validator-var
	 *  name="mask"
	 *  value="^\d{3}-\d{4}$"
	 * @struts.validator-args
	 *  arg0resource="inputForm.zipcode"
	 * @param string
	 */
	public void setZipcode(String string) {
		zipcode = string;
	}

}
