#! /usr/bin/perl

initForm();

showMessage($FORM{'message'});

exit;

sub showMessage {
	my($msg) = shift;

print <<EOD;
Content-type: text/html

<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS">
</head>

<body>

$msg

</body>
</html>
EOD
}

sub initForm {
	my($buf, @query, $name, $value);
	my($method);

	$method = $ENV{'REQUEST_METHOD'};
	$method =~ tr/a-z/A-Z/;
	if ($method eq 'POST') {
		read(STDIN, $buf, $ENV{'CONTENT_LENGTH'});
	} elsif ($method eq 'GET') {
		$buf = $ENV{'QUERY_STRING'};
	}

	@query = split(/&/, $buf);
	foreach $buf (@query) {
		($name, $value) = split(/=/, $buf);
		$value =~ tr/+/ /;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;

		# ^O̖
		$value =~ s/&/&amp;/g;
		$value =~ s/</&lt;/g;
		$value =~ s/>/&gt;/g;
		$value =~ s/"/&quot;/g;
		$value =~ s/'/&#x27;/g;

		$FORM{$name} = $value;
	}
}


