import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.geronimo.GeronimoContextManager;

/**
 * HelloC^[tF[XGBean.
 */
public class HelloGBean implements Hello, GBeanLifecycle {
	// GBEAN_INFÔO̎n܂
	private static final GBeanInfo GBEAN_INFO = createGBeanInfo();

	/**
	 * Geronimov郁\bh. o[Wł́Apublic static final GBeanInfoƂȂĂ΂悩悤A
	 * as isł̓\bhpӂKv͗l.
	 */
	public static GBeanInfo getGBeanInfo() {
		return GBEAN_INFO;
	}

	/**
	 * NXŗBꑶ݂GBEAN_INFO𐶐ׂ̃\bh.
	 * 
	 * @return ꂽGBeanInfo
	 */
	private static GBeanInfo createGBeanInfo() {
		final GBeanInfoBuilder builder = new GBeanInfoBuilder(HelloGBean.class);
		builder.addAttribute("contextName", String.class, true);
		builder.addReference("invoker", Invoker.class);

		// ɕKvȂÅmFɂ͎giƎv܂B
		// magicȂ̂ŁAvt@Cɉe^ȂB
		builder.addAttribute("objectName", String.class, false);// gObjectNametoString
		builder.addAttribute("kernel", Kernel.class, false);// GeronimoJ[l
		builder.setConstructor(new String[] { "contextName", "invoker",
				"objectName", "kernel" });

		return builder.getBeanInfo();
	}

	// GBEAN_INFÔȌI

	// HelloGBeanɓL̏ɕKvȃvpeB
	/**
	 * HelloGBeanbindJNDIReLXg
	 */
	private final String contextName;

	/**
	 * R[obN̈˗
	 */
	private final Invoker invoker;

	/**
	 * OłˁB ʓIɌāAp邱Ƃl protectedɂāA this.getClass()ŃNX擾悤ɂ
	 * TuNX(hNX)łloggĕ֗Ǝ͎v܂B
	 */
	protected final Log log = LogFactory.getLog(this.getClass());

	/**
	 * HelloGBean𐶐ׂ̗B̃RXgN^.
	 * 
	 * @param contextName
	 *            HelloGBeanbindJNDIReLXg
	 * @param invoker
	 *            R[obN̈˗
	 * @param objectName
	 *            debugpAgObjectNametoString
	 * @param kernel
	 *            debugpAgObjectNametoString
	 */
	public HelloGBean(final String contextName, final Invoker invoker,
			final String objectName, final Kernel kernel) {
		if (log.isInfoEnabled())
			log
					.info("enter HelloGBean(String contextName, Invoker invoker, String objectName, Kernel kernel)");

		if (log.isDebugEnabled()) {
			log.debug("parameter contextName: " + contextName);
			log.debug("parameter invoker.getClass(): " + invoker.getClass());
			log.debug("parameter objectName" + objectName);
			log.debug("parameter kernel.getClass(): " + kernel.getClass());
		}

		this.contextName = contextName;
		this.invoker = invoker;
	}

	/**
	 * GBean̏Ԃ`. NԂA~Ԃ̔ɗp̂ŁA VACY̑ΏۂƂA: transient
	 * }`XbhɑΉKv邽: volatile ƂĂB
	 */
	private transient volatile Locker locker = null;

	/**
	 * GBean̏ԂK肷. ́A N/~Ԃ̕\ O[XtȒ~̎ɂB
	 */
	private class Locker {

		/**
		 * Xgbv̔p
		 */
		private volatile boolean isStopping = false;

		/**
		 * ǂꂾ̃XbhLocker̒ŏ҂ɂȂĂ̂
		 */
		private volatile int accessCount = 0;

		/**
		 * HelloServicëϏ. }`XbhɑgݍݑΉȂÁ̕A new JNIHelloService()
		 * ōςނ悤ɂȂł傤B
		 */
		private final HelloService base = new InvokingHelloService(
				new JNIHelloService(), invoker);

		// private final HelloService base = new JNIHelloService();

		/**
		 * RXgN^.
		 */
		public Locker() {
			if (!base.start())
				throw new IllegalStateException("NŎs");
		}

		/**
		 * ҂ɂȂĂ̂JEgׂ̓\bh.
		 */
		private synchronized void inc() {
			if (isStopping)
				throw new IllegalStateException("I");
			++accessCount;
		}

		/**
		 * Îׂ̓\bh. ҂̂̂ȂȂAIԂɂȂĂ΁AI\bhNB
		 */
		private synchronized void dec() {
			--accessCount;
			if (accessCount == 0 && isStopping)
				this.notifyAll();
		}

		/**
		 * APȈϏ\bh. O[XtȒf̑ΏۂƂȂ܂B
		 * 
		 * @param name
		 *            Hello.helloĂ񂾑
		 * @return "Hello!! " + (name != null)?name: ""; ҂B
		 */
		public String hello(final String name) {
			inc();// ɂȂĂ邱ƂJEg
			try {
				return base.hello(name);
			} finally {
				dec();// mɏςɂȂL^
			}
		}

		/**
		 * doFail̏Ϗ\bh. ̃\bhO[XtȒf̑ΏۂƂȂ܂B
		 */
		public void fail() {
			inc();// ɂȂĂ邱ƂJEg
			try {
				base.fail();
			} finally {
				dec();// mɏςɂȂL^
			}
		}

		/**
		 * ~. ̎̒ŃO[XtȎsĂ.
		 */
		public synchronized void stop() {
			if (isStopping)
				throw new IllegalStateException("I");
			isStopping = true;
			while (true) {
				if (accessCount == 0) {
					if (!base.stop())
						throw new IllegalStateException("IŎs");
					return;
				}
				try {
					this.wait();
				} catch (InterruptedException e) {
				}
			}
		}
	}

	/**
	 * hellõt@T[h. locker.helloɏϏ.
	 */
	public String hello(String name) {
		log.info("enter hello(String)");
		try {
			final Locker locker = this.locker;// this.locker͂nullɂȂ邩킩ȂB
			if (locker == null)
				throw new IllegalStateException("܂~");
			final String result = locker.hello(name);
			log.debug("success hello(name)");
			return result;
		} catch (RuntimeException e) {
			log.warn("helloŎs", e);
			throw e;
		} catch (Error e) {
			log.warn("helloŎs", e);
			throw e;
		}
	}

	/**
	 * GBeanLifecycle̎\bh.
	 */
	public void doFail() {
		log.info("enter doFail()");
		try {
			final Locker locker = this.locker;// this.locker͂nullɂȂ邩킩ȂB
			if (locker == null)
				throw new IllegalStateException("܂~");
			locker.fail();
		} catch (RuntimeException e) {
			log.warn("doFailŎs", e);
			throw e;
		} catch (Error e) {
			log.warn("doFailŎs", e);
			throw e;
		}
		log.debug("success doFail()");
	}

	/**
	 * GBeanLifecycle̎\bh.
	 */
	public synchronized void doStart() throws Exception {
		log.info("enter doStart()");
		try {
			if (locker != null)
				throw new IllegalStateException("ɋNς");
			final Locker locker = new Locker();
			this.locker = locker;

			try {
				GeronimoContextManager.bind(contextName, this);
				log.info("bind to: " + contextName);
			} catch (Exception e) {
				log.warn("exception doStart()", e);
				this.locker = null;
				locker.stop();
				throw e;
			}
		} catch (Exception e) {
			log.warn("NɎs", e);
			throw e;
		} catch (Error e) {
			log.warn("NɎs", e);
			throw e;
		}
		log.debug("success doStart()");
	}

	/**
	 * GBeanLifecycle̎\bh.
	 */
	public synchronized void doStop() throws Exception {
		log.info("enter doStop()");
		try {
			final Locker locker = this.locker;// this.locker͂nullɂȂ邩킩ȂB
			if (locker == null)
				throw new IllegalStateException("܂~");
			this.locker = null;// ȍ~̏悤Ƃ܂ƁAIԂɂĂ
			try {
				GeronimoContextManager.unbind(contextName);
			} finally {
				locker.stop();
			}
		} catch (Exception e) {
			log.warn("~Ɏs", e);
			throw e;
		} catch (Error e) {
			log.warn("~Ɏs", e);
			throw e;
		}
		log.debug("success doStop()");
	}
}
