import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;

/**
 * JNIHelloService.
 */
public class JNIHelloService implements HelloService {
	static {
		//sample.java2ruby.dllJVM̓ĂvZbTɃ[hĂB
		//Ȁ͌ł͖낤B
		//ȂȂAÓIwqstatic {}ŝClass[hꂽ^C~OłB
		//GeronimołClassLoader݂ĂAAIɔj꓾B
		//̌ʁAēxNX[h鎖ɂāAloadLibrarŷł邪A
		//dllvZXɃ[hĂ̂ŁAExceptionĂB
		//ׁ̈Ał́ArunningԂstopꍇɂ͕KAGeronimo̍ċNKv
		System.loadLibrary("sample.java2ruby");
	}


	//VXẽftHg̃GR[hǂݍłB
	private final static String encoding =
		System.getProperties().getProperty("file.encoding");
	
	public String hello(String name) {
		try {
			if (name == null)
				return new String(helloJNI(new byte[0]), encoding);

			//p[^ftHgGR[hŃGR[hA
			//ʂftHgGR[hŃfR[hĂ̂́A
			//RubyC++VXeˑ̃GR[hŕ񏈗ĂׂłB
			return new String(helloJNI(name.getBytes(encoding)), encoding);
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	
	//ȉAlCeBu\bh
	
	private native byte[] helloJNI(byte[] name);

	public native boolean start();
	public native boolean stop();
	public native void fail();
}
