import javax.management.ObjectName;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;

/**
 * Ruby^C𐧌䂷GBean. ^C𐧌䂷ƋThread̊ǗsĂ܂B
 */
public class RubyGBean implements GBeanLifecycle, Invoker {
	/**
	 * Ruby^CɃANZXłB̃XbhێĂ܂.
	 * {ł΁Astatic͖A܂肭oȂ悤Ȃ̂ŁA staticƂĂ܂B
	 */
	private static Invoker invoker = new UniqueThreadInvoker();

	// GBEAN_INFÔO̎n܂
	private static final GBeanInfo GBEAN_INFO = createGBeanInfo();

	/**
	 * Geronimov郁\bh. o[Wł́Apublic static final GBeanInfoƂȂĂ΂悩悤A
	 * as isł̓\bhpӂKv͗l.
	 */
	public static GBeanInfo getGBeanInfo() {
		return GBEAN_INFO;
	}

	/**
	 * NXŗBꑶ݂GBEAN_INFO𐶐ׂ̃\bh.
	 * 
	 * @return ꂽGBeanInfo
	 */
	private static GBeanInfo createGBeanInfo() {
		final GBeanInfoBuilder builder = new GBeanInfoBuilder(RubyGBean.class);

		// ɕKvȂÅmFɂ͎giƎv܂B
		// magicȂ̂ŁAvt@Cɉe^ȂB
		builder.addAttribute("objectName", String.class, false);// gObjectNametoString
		builder.setConstructor(new String[] { "objectName" });

		// 荇AǉĂ݂AȂ悤ȋCcA
		builder.addOperation("invoke", new Class[] { Runnable.class });

		// ̃NXInvokerC^[tF[XĂ鎖\Ă܂B
		builder.addInterface(Invoker.class);
		return builder.getBeanInfo();
	}

	/**
	 * OłˁB ʓIɌāAp邱Ƃl protectedɂāA this.getClass()ŃNX擾悤ɂ
	 * TuNX(hNX)łloggĕ֗Ǝ͎v܂B
	 */
	protected final Log log = LogFactory.getLog(this.getClass());

	/**
	 * RubyGBean𐶐ׂ̗B̃RXgN^.
	 * 
	 * @param objectName
	 *            debugpAgObjectNametoString
	 */
	public RubyGBean(final String objectName) {
		if (log.isInfoEnabled())
			log.info("enter RubyGBean(final String objectName)");

		if (log.isDebugEnabled())
			log.debug("parameter objectName: " + objectName);
	}

	/**
	 * GBean̏Ԃ`. NԂA~Ԃ̔ɗp̂ŁA VACY̑ΏۂƂA: transient
	 * }`XbhɑΉKv邽: volatile ƂĂB
	 */
	private transient volatile Locker locker = null;

	/**
	 * GBean̏ԂK肷. ́A N/~Ԃ̕\ O[XtȒ~̎ɂB
	 */
	private class Locker {

		/**
		 * Xgbv̔p
		 */
		private volatile boolean isStopping = false;

		/**
		 * ǂꂾ̃XbhLocker̒ŏ҂ɂȂĂ̂
		 */
		private volatile int accessCount = 0;

		/**
		 * RubyServicëϏ. }`XbhɑgݍݑΉȂÁ̕A new JNIRubyService()
		 * ōςނ悤ɂȂł傤B
		 */
		private final RubyService base = new InvokingRubyService(
				new JNIRubyService(), invoker);

		/**
		 * RXgN^.
		 */
		public Locker() {
			if (!base.start())
				throw new IllegalStateException("NŎs");
		}

		/**
		 * ҂ɂȂĂ̂JEgׂ̓\bh.
		 */
		private synchronized void inc() {
			if (isStopping)
				throw new IllegalStateException("I");
			++accessCount;
		}

		/**
		 * Îׂ̓\bh. ҂̂̂ȂȂAIԂɂȂĂ΁AI\bhNB
		 */
		private synchronized void dec() {
			--accessCount;
			if (accessCount == 0 && isStopping)
				this.notifyAll();
		}

		/**
		 * SPȈϏ\bh. O[XtȒf̑ΏۂƂȂ܂B
		 * 
		 * @param runner
		 *            R[obNΏ
		 */
		public void invoke(final Runnable runner) {
			inc();// ɂȂĂ邱ƂJEg
			try {
				invoker.invoke(runner);
			} finally {
				dec();// mɏςɂȂL^
			}
		}

		/**
		 * doFail̏Ϗ\bh. ̃\bhO[XtȒf̑ΏۂƂȂ܂B
		 */
		public void fail() {
			inc();
			try {
				base.fail();
			} finally {
				dec();
			}
		}

		/**
		 * ~. ̎̒ŃO[XtȎsĂ.
		 */
		public synchronized void stop() {
			if (isStopping)
				throw new IllegalStateException("I");
			isStopping = true;
			while (true) {
				if (accessCount == 0) {
					if (!base.stop())
						throw new IllegalStateException("IŎs");
					return;
				}
				try {
					this.wait();
				} catch (InterruptedException e) {
				}
			}
		}
	}

	/**
	 * invokẽt@T[h. locker.invokeɏϏ.
	 */
	public void invoke(final Runnable runner) {
		log.info("enter invoke(Runnable)");
		try {
		final Locker locker = this.locker;
		if (locker == null)
			throw new IllegalStateException("܂~");
		locker.invoke(runner);
		} catch (RuntimeException e) {
			log.warn("invokeŗO", e);
			throw e;
		} catch (Error e) {
			log.warn("invokeŗO", e);
			throw e;
		}

		log.debug("success invoke(Runnable)");
	}

	/**
	 * GBeanLifecycle̎\bh.
	 */
	public void doFail() {
		log.info("enter doFail()");
		try {
		final Locker locker = this.locker;// this.locker͂nullɂȂ邩킩ȂB
		if (locker == null)
			throw new IllegalStateException("܂~");
		locker.fail();
		} catch (RuntimeException e) {
			log.warn("doFailŗO", e);
			throw e;
		} catch (Error e) {
			log.warn("doFailŗO", e);
			throw e;
		}
		log.debug("success doFail()");
	}

	/**
	 * GBeanLifecycle̎\bh.
	 */
	public synchronized void doStart() throws Exception {
		log.info("enter doStart()");
		try {
			// N`FbN
			if (locker != null)
				throw new IllegalStateException("ɋNς");
			locker = new Locker();
		} catch (Exception e) {
			log.warn("NɎs", e);
			throw e;
		} catch (Error e) {
			log.warn("NɎs", e);
			throw e;
		}
		log.debug("success doStart()");
	}

	/**
	 * GBeanLifecycle̎\bh.
	 */
	public synchronized void doStop() throws Exception {
		log.info("enter doStop()");
		try {
			final Locker locker = this.locker;
			if (locker == null)
				throw new IllegalStateException("܂~");
			this.locker = null;// ȍ~̏悤Ƃ܂ƁAIԂɂĂ
			locker.stop();
		} catch (Exception e) {
			log.warn("~Ɏs", e);
			throw e;
		} catch (Error e) {
			log.warn("~Ɏs", e);
			throw e;
		}
		log.debug("success doStop()");
	}
}
