#include <string>
#include <ruby.h>
#include "RubyManager.hpp"
#include "HelloRuby.hpp"

HelloRuby HelloRuby::self = HelloRuby();

HelloRuby::HelloRuby() {
}

HelloRuby::~HelloRuby() {
}

VALUE HelloRuby::execute(const char* methodName, int argc, VALUE* argv) const {
	return RubyManager::getInstance().execute(value, methodName, argc, argv);
}

std::string HelloRuby::hello(const std::string& name) const {
	VALUE parameter = RubyManager::getInstance().newString(name);
	VALUE result = execute("hello", 1, 	&parameter);
	return std::string(RSTRING(result)->ptr, RSTRING(result)->len);
}

void HelloRuby::start() {
	RubyManager::getInstance().load("HelloService.rb");
	value = RubyManager::getInstance().eval("HelloService.instance");
	
	execute("start", 0, NULL);
}

void HelloRuby::stop() {
	execute("stop", 0, NULL);
	value = NULL;
}

void HelloRuby::fail() {
	execute("fail", 0, NULL);
}

HelloRuby& HelloRuby::getInstance() {
	return self;
}
