#ifndef HELLORUBY_HPP_
#define HELLORUBY_HPP_

#include <string>
#include <ruby.h>

/*
 * HelloService.rbĂяoB
 * Singleton patterngĂ邪AHelloService.rbSingletonŎA
 * ̏ꍇSingleton Pattern͂܂_߂ł͂Ȃ낤B
 */
class HelloRuby {
private:
	static HelloRuby self;
	VALUE value;
private:
	explicit HelloRuby();
	virtual ~HelloRuby();
private:
	VALUE execute(const char* methodName, int argc, VALUE* argv) const;
public:
	std::string hello(const std::string& name) const;
	void start();
	void stop();
	void fail();
	static HelloRuby& getInstance();
};

#endif /*HELLORUBY_HPP_*/
