#include <jni.h>
#include "JNIHelloService.h"
#include "HelloRuby.hpp"
#include "java_utility.hpp"

extern "C" {
/*
 * Class:     JNIHello
 * Method:    helloJNI
 * Signature: ([B)[B
 */
JNIEXPORT jbyteArray JNICALL Java_JNIHelloService_helloJNI(JNIEnv* penvironment, jobject self, jbyteArray name) {
	return string2java_byte_array(penvironment, HelloRuby::getInstance().hello(java_byte_array2string(penvironment, name)));
}

/*
 * Class:     JNIHello
 * Method:    start
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_JNIHelloService_start(JNIEnv* penvironment, jobject self) {
	HelloRuby::getInstance().start();
	return JNI_TRUE;
}

/*
 * Class:     JNIHello
 * Method:    stop
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_JNIHelloService_stop(JNIEnv* penvironment, jobject self) {
	HelloRuby::getInstance().stop();
	return JNI_TRUE;
}

/*
 * Class:     JNIHello
 * Method:    fail
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_JNIHelloService_fail(JNIEnv *, jobject) {
	HelloRuby::getInstance().fail();
}

}
