#include <windows.h>

#include <ruby.h>
#include "RubyManager.hpp"


//̎Windowsp̎łB


RubyFunctionTable::RubyFunctionTable():
	hInstDLL(NULL),
	pNtInitialize(NULL),
	pruby_init(NULL),
	pruby_init_loadpath(NULL),
	pruby_finalize(NULL),
	prb_require(NULL),
	prb_eval_string(NULL),
	prb_str_new(NULL),
	prb_funcall2(NULL),
	prb_intern(NULL) {};

RubyFunctionTable::RubyFunctionTable(
	HINSTANCE _hInstDLL,
	PNtInitialize _pNtInitialize,
	Pruby_init _pruby_init,
	Pruby_init_loadpath _pruby_init_loadpath,
	Pruby_finalize _pruby_finalize,
	Prb_require _prb_require,
	Prb_eval_string _prb_eval_string,
	Prb_str_new _prb_str_new,
	Prb_funcall2 _prb_funcall2,
	Prb_intern _prb_intern):
	hInstDLL(_hInstDLL),
	pNtInitialize(_pNtInitialize),
	pruby_init(_pruby_init),
	pruby_init_loadpath(_pruby_init_loadpath),
	pruby_finalize(_pruby_finalize),
	prb_require(_prb_require),
	prb_eval_string(_prb_eval_string),
	prb_str_new(_prb_str_new),
	prb_funcall2(_prb_funcall2),
	prb_intern(_prb_intern){};

RubyFunctionTable::RubyFunctionTable(const RubyFunctionTable& _source):
	hInstDLL(_source.hInstDLL),
	pNtInitialize(_source.pNtInitialize),
	pruby_init(_source.pruby_init),
	pruby_init_loadpath(_source.pruby_init_loadpath),
	pruby_finalize(_source.pruby_finalize),
	prb_require(_source.prb_require),
	prb_eval_string(_source.prb_eval_string),
	prb_str_new(_source.prb_str_new),
	prb_funcall2(_source.prb_funcall2), 
	prb_intern(_source.prb_intern){};

void RubyFunctionTable::NtInitialize(int* argc, char*** argv) const {
	(*pNtInitialize)(argc, argv);
}
void RubyFunctionTable::ruby_init() const {
	(*pruby_init)();
}
void RubyFunctionTable::ruby_init_loadpath() const {
	(*pruby_init_loadpath)();
}
void RubyFunctionTable::ruby_finalize() const {
	(*pruby_finalize)();
}
VALUE RubyFunctionTable::rb_require(const char* libName) const {
	return (*prb_require)(libName);
}
VALUE RubyFunctionTable::rb_eval_string(const char* script) const {
	return (*prb_eval_string)(script);
}
VALUE RubyFunctionTable::rb_str_new(const char* str, long count) const {
	return (*prb_str_new)(str, count);
}
VALUE RubyFunctionTable::rb_funcall2(VALUE object, ID id, int count, const VALUE* pvalue) const {
	return (*prb_funcall2)(object, id, count, pvalue);
}
ID RubyFunctionTable::rb_intern (const char* methodName) const {
	return (*prb_intern)(methodName);
}

bool RubyFunctionTable::FreeLibrary() const {
	BOOL result = ::FreeLibrary(hInstDLL);
	return result;
}


namespace {
	int argc = 0;
	char** argv = new char*[1];
}


RubyManager RubyManager::self = RubyManager();

RubyManager::RubyManager(): rubyFunctionTable() {}

RubyManager::~RubyManager() {}


bool RubyManager::start() {
	HINSTANCE _hInstDLL = LoadLibrary("msvcrt-ruby18.dll");
	if (_hInstDLL == NULL) return false;

	rubyFunctionTable = RubyFunctionTable(
		_hInstDLL,
		(RubyFunctionTable::PNtInitialize) GetProcAddress(_hInstDLL,"NtInitialize"),
		(RubyFunctionTable::Pruby_init) GetProcAddress(_hInstDLL,"ruby_init"),
		(RubyFunctionTable::Pruby_init_loadpath) GetProcAddress(_hInstDLL, "ruby_init_loadpath"),
		(RubyFunctionTable::Pruby_finalize) GetProcAddress(_hInstDLL, "ruby_finalize"),
		(RubyFunctionTable::Prb_require) GetProcAddress(_hInstDLL, "rb_require"),
		(RubyFunctionTable::Prb_eval_string) GetProcAddress(_hInstDLL, "rb_eval_string"),
		(RubyFunctionTable::Prb_str_new) GetProcAddress(_hInstDLL, "rb_str_new"),
		(RubyFunctionTable::Prb_funcall2) GetProcAddress(_hInstDLL, "rb_funcall2"),
		(RubyFunctionTable::Prb_intern) GetProcAddress(_hInstDLL, "rb_intern")
	);
	argv[0] = "";

    rubyFunctionTable.NtInitialize(&argc, &argv);

	rubyFunctionTable.ruby_init();
	rubyFunctionTable.ruby_init_loadpath();

	return true;
}

bool RubyManager::stop() {
	rubyFunctionTable.ruby_finalize();
	BOOL result = rubyFunctionTable.FreeLibrary();
	rubyFunctionTable = RubyFunctionTable();
	return result;
}

void RubyManager::fail() {
}

void RubyManager::load(const char* rubyFileName) const {
	rubyFunctionTable.rb_require(rubyFileName);
}

VALUE RubyManager::eval(const char* script) const {
	return rubyFunctionTable.rb_eval_string(script);
}

VALUE RubyManager::newString(const std::string& name) const {
	return rubyFunctionTable.rb_str_new(name.c_str(), name.size());
}

VALUE RubyManager::execute(VALUE object, const char* methodName, int argc, VALUE* argv) const {
	return rubyFunctionTable.rb_funcall2(object, rubyFunctionTable.rb_intern(methodName), argc, argv);
}

RubyManager& RubyManager::getInstance() {
	return self;
}
