#ifndef RUBYMANAGER_HPP_
#define RUBYMANAGER_HPP_
#include <string>
#include <ruby.h>

/*
 * Ruby ^C̊֐|C^ێ.
 */
class RubyFunctionTable {
public:
	typedef void (*PNtInitialize)(int*, char***);
	typedef void (*Pruby_init)();
	typedef void (*Pruby_init_loadpath)();
	typedef void (*Pruby_finalize)();
	typedef VALUE (*Prb_require) (const char*);
	typedef VALUE (*Prb_eval_string) (const char*);
	typedef VALUE (*Prb_str_new) (const char*, long);
	typedef VALUE (*Prb_funcall2) (VALUE, ID, int, const VALUE*);
	typedef ID (*Prb_intern) (const char*);

private:
	HINSTANCE hInstDLL;
	PNtInitialize pNtInitialize;
	Pruby_init pruby_init;
	Pruby_init_loadpath pruby_init_loadpath;
	Pruby_finalize pruby_finalize;
	Prb_require prb_require;
	Prb_eval_string prb_eval_string;
	Prb_str_new prb_str_new;
	Prb_funcall2 prb_funcall2;
	Prb_intern prb_intern;

public:
	RubyFunctionTable();

	RubyFunctionTable(
		HINSTANCE _hInstDLL,
		PNtInitialize _pNtInitialize,
		Pruby_init _pruby_init,
		Pruby_init_loadpath _pruby_init_loadpath,
		Pruby_finalize _pruby_finalize,
		Prb_require _prb_require,
		Prb_eval_string _prb_eval_string,
		Prb_str_new _prb_str_new,
		Prb_funcall2 _prb_funcall2,
		Prb_intern _prb_intern
	);

	RubyFunctionTable(const RubyFunctionTable& _source);

public:
	void NtInitialize(int* argc, char*** argv) const;
	void ruby_init() const;
	void ruby_init_loadpath() const;
	void ruby_finalize() const;
	VALUE rb_require(const char* libName) const;
	VALUE rb_eval_string(const char* script) const;
	VALUE rb_str_new(const char* str, long count) const;
	VALUE rb_funcall2(VALUE object, ID id, int count, const VALUE* pvalue) const;
	ID rb_intern (const char* methodName) const;
	bool FreeLibrary() const;
};

/* 
 * Ruby ^CǗ.
 * Singlton PatternKpĂ̂́ABDLLǂݍނ߂ŁA
 * vZXԏBŖƂȂłB
 */
class RubyManager {
private:
	static RubyManager self;
	RubyFunctionTable rubyFunctionTable;

private:
	explicit RubyManager();
	virtual ~RubyManager();

public:
	bool start();
	bool stop();
	void fail();
	void load(const char* rubyFileName) const;
	VALUE eval(const char* script) const;
	VALUE newString(const std::string& name) const;
	VALUE execute(VALUE object, const char* methodName, int argc, VALUE* argv) const;

public:
	static RubyManager& getInstance();
};

#endif /*RUBYMANAGER_HPP_*/
