#include <jni.h>
#include <string>
#include <vector>
#include "java_utility.hpp"

std::string java_byte_array2string(JNIEnv* penvironment, jbyteArray source) {
	const jsize size = penvironment->GetArrayLength(source);
	if (size == 0) return std::string();
	std::vector<char> buffer(size);
	penvironment->GetByteArrayRegion(source, 0, size, (jbyte*)&buffer[0] ); 
	return std::string(&buffer[0], buffer.size());
}

jbyteArray string2java_byte_array(JNIEnv* penvironment, const std::string source) {
	 jbyteArray target = penvironment->NewByteArray(source.size());//GCǗGA??
	penvironment->SetByteArrayRegion(target, 0, source.size(), (const jbyte*)source.c_str());
	return target;
}
