import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.geronimo.kernel.KernelRegistry;

public class HelloGBeanTest extends AbstractHelloTest {
	private RubyGBean ruby = null;
	private HelloGBean hello = null;
	public HelloGBeanTest() {
		super();
	}
	public HelloGBeanTest(String arg0) {
		super(arg0);
	}
    protected void setUp() throws Exception {
    	super.setUp();
        System.setProperty("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.geronimo.naming");
        System.setProperty("java.naming.provider.url", "rmi://localhost:1099");

        ruby = new RubyGBean("ق[");
		ruby.doStart();

        hello = new HelloGBean("/gbean/helloGBean", ruby, "ӂ[", KernelRegistry.getKernel("geronimo"));
		hello.doStart();
    }
    protected void tearDown() throws Exception {
		try {
			hello.doStop();
		} catch (Exception e) {
			e.printStackTrace();
		}

		try {
			ruby.doStop();
		} catch (Exception e) {
			e.printStackTrace();
		}

		super.tearDown();
	}

    protected Hello getHello() {
    	try {
			return (Hello)new InitialContext().lookup("geronimo:/gbean/helloGBean");
		} catch (NamingException e) {
			throw new RuntimeException(e);
		}
	}

	public void testLookupHello() throws Exception {
        InitialContext context = new InitialContext();
    	assertTrue(context.lookup("geronimo:/gbean/helloGBean") instanceof Hello);
    }

	public void testDo0001() {
		boolean flag = true;
		final HelloGBean hello = (HelloGBean)getHello();
		//started
		try {
			hello.hello("hoge");
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("first hello", flag);
		try {
			hello.doStart();
			flag = false;
		} catch (Throwable t) {
			flag = true;
		}
		assertTrue("first start", flag);

		try {
			hello.doFail();
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("first fail", flag);

		try {
			hello.doFail();
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("second fail", flag);

		try {
			hello.doStop();
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("first stop", flag);

		//stopped
		try {
			hello.doStop();
			flag = false;
		} catch (Throwable t) {
			flag = true;
		}
		assertTrue("second stop", flag);

		try {
			hello.doFail();
			flag = false;
		} catch (Throwable t) {
			flag = true;
		}
		assertTrue("third fail", flag);

		try {
			hello.doStart();
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("second start", flag);

		//started
		try {
			hello.doStart();
			flag = false;
		} catch (Throwable t) {
			flag = true;
		}
		assertTrue("third start", flag);

		try {
			hello.doFail();
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("4th fail", flag);

		try {
			hello.doFail();
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("5th fail", flag);

		try {
			hello.doStop();
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("third stop", flag);

		//stoped
		try {
			hello.hello("hoge");
			flag = false;
		} catch (Throwable t) {
			flag = true;
		}
		assertTrue("second hello", flag);

		try {
			hello.doStop();
			flag = false;
		} catch (Throwable t) {
			flag = true;
		}
		assertTrue("4th stop", flag);

		try {
			hello.doFail();
			flag = false;
		} catch (Throwable t) {
			flag = true;
		}
		assertTrue("6th fail", flag);

		try {
			hello.doStart();
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("4th start", flag);

		//started
		try {
			hello.doFail();
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("6th fail", flag);

		try {
			hello.hello("hoge");
			flag = true;
		} catch (Throwable t) {
			flag = false;
		}
		assertTrue("third hello", flag);
	}
}
