import java.util.Date;

import junit.framework.TestCase;

public class UniqueThreadInvokerTest extends TestCase {
	private static void sleeping() {
		try {
			Thread.sleep(1);
		} catch (InterruptedException e) {
		}
	}
	class TestRunner00001 implements Runnable {
		final String text;
		public TestRunner00001(final String text) {
			this.text = text;
		}
		public void run() {
			System.out.println(text + "running time: " + new Date());
			sleeping();;
		}
	}
	public void test0001() {
		final UniqueThreadInvoker pool = new UniqueThreadInvoker();
		for (int i = 0; i < 100; ++i) {
			final String text = "[" + i + "]: ";
			System.out.println(text +  "start time: " + new Date());
			
			pool.invoke(new TestRunner00001(text));
			System.out.println(text + "end time: " + new Date());
		}
	}
	class TestRunner00002 implements Runnable {
		final String text;
		final UniqueThreadInvoker invoker;
		public TestRunner00002(final UniqueThreadInvoker invoker, final String text) {
			this.invoker = invoker;
			this.text = text;
		}
		public void run() {
			for (int i = 0; i < 10; ++i) {
				final String text = this.text + "[" + i + "]: ";
				System.out.println(text +  "start time: " + new Date());
				invoker.invoke(new TestRunner00001(text));
				System.out.println(text + "end time: " + new Date());
				sleeping();
			}
		}
	}

	public void test0002() {
		final UniqueThreadInvoker invoker = new UniqueThreadInvoker();
		final Thread[] threads = new Thread[10];
		
		for (int i = 0; i <10; ++i) {
			threads[i] = new Thread(new TestRunner00002(invoker, "thread [" + i + "]"));
			threads[i].start();
			try {
			threads[i].join();
			} catch (InterruptedException e) {
			}
		}
	}
}
