// CDictionaryCOM.cpp : R\[ AvP[Vp̃Gg |Cg̒`
//

#include "stdafx.h"

#define HRESULT long
#define	ULONG	unsigned long
#define PLONG	unsigned long*
#define DWORD	unsigned long
#define WORD	unsigned short
#define BYTE	unsigned char
#define BOOL	long

typedef struct  _GUID
{
    DWORD	Data1;
    WORD	Data2;
    WORD	Data3;
    BYTE	Data4[8];
}	GUID;

typedef GUID CLSID;
typedef GUID IID;
#define REFCLSID	const CLSID &
#define REFIID		const IID &

// UnknownC^[tF[X̒`
// IID_IUnknown {00000000-0000-0000-C000-000000000046}
static const IID IID_IUnknown = 
{ 0x00000000, 0x0000, 0x0000, { 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46 } };

// IUnknownC^[tF[X̒`
class IUnknown
{
public:
    virtual HRESULT  __stdcall	QueryInterface(REFIID riid, void** ppvObj) = 0;
    virtual ULONG	 __stdcall	AddRef() = 0;
    virtual ULONG	 __stdcall	Release() = 0;
};

// GUIDGEN.EXEgIDictionaryC^[tF[XpIID𐶐
// IID_IDictionary {48CAC0E1-58D2-11d3-B169-000021C38DD8}
static const IID IID_IDictionary = 
{ 0x48cac0e1, 0x58d2, 0x11d3, { 0xb1, 0x69, 0x0, 0x0, 0x21, 0xc3, 0x8d, 0xd8 } };

// GUIDGEN.EXEgCDictionaryNXpCLSID𐶐
// CLSID_CDictionary {48CAC0E1-58D2-11d3-B169-000021C38DD9}
static const CLSID CLSID_CDictionary = 
{ 0x48cac0e1, 0x58d2, 0x11d3, { 0xb1, 0x69, 0x0, 0x0, 0x21, 0xc3, 0x8d, 0xd9 } };


// IDictionaryC^[tF[X̒`
class IDictionary  : public IUnknown
{
public:
	virtual HRESULT	__stdcall LookupWord(char* lpszEword, char* lpszJword, BOOL* pbResult) = 0;
};

struct EJ_Dictionary {
	char Eword_dic[10];	// pP
	char Jword_dic[10]; // aP
} dic[] = {{"pen","y"}, {"pencil","M"},{"book","{"}};

// CDictionaryNX̒`
class CDictionary : public IDictionary
{
private:
	ULONG	m_dwRef;	// QƃJEg
	int		m_nWord;	// Pꐔ
public:
	HRESULT __stdcall	QueryInterface(REFIID iid, void** ppvObj);
    ULONG	__stdcall	AddRef();
    ULONG	__stdcall	Release();
	HRESULT	__stdcall	LookupWord(char* lpszEword, char* lpszJword, BOOL* pbResult);
	CDictionary() : m_dwRef(0) { 
		// ̒P̌Zo
		m_nWord = sizeof(dic)/sizeof(EJ_Dictionary);
	}
	~CDictionary() { }
};

#include "string.h"
#define	TRUE			1
#define	FALSE			0
#define	S_OK			0
#define S_FALSE			1
#define FOUND			TRUE
#define NotFOUND		FALSE
#define E_NOINTERFACE	0x80000004L
#define REFGUID			const GUID &
#define IsEqualIID(riid1, riid2) IsEqualGUID(riid1, riid2)

BOOL  IsEqualGUID(REFGUID rguid1, REFGUID rguid2)
{
   return (
      ((PLONG) &rguid1)[0] == ((PLONG) &rguid2)[0] &&
      ((PLONG) &rguid1)[1] == ((PLONG) &rguid2)[1] &&
      ((PLONG) &rguid1)[2] == ((PLONG) &rguid2)[2] &&
      ((PLONG) &rguid1)[3] == ((PLONG) &rguid2)[3]);
}


HRESULT __stdcall CDictionary::QueryInterface(REFIID riid, void** ppvObj) 
{ 
	if (IsEqualIID(riid ,IID_IUnknown)) // if (!memcmp(&riid ,&IID_IUnknown,sizeof(GUID)))
		// UnknownC^[tF[X̃AhX*ppvObjɐݒ肷
        *ppvObj = static_cast<IUnknown*>(this);		
		// *ppvObj = (IUnknown*)this;	
	else if(IsEqualIID(riid ,IID_IDictionary))
		// IDictionaryC^[tF[X̃AhX*ppvObjɐݒ肷
		*ppvObj = this;
	else
	{	
		// C^[tF[XȂꍇ
		*ppvObj = NULL;
		return E_NOINTERFACE;
    }
	// C^[tF[XƂɂ͎QƃJEg𑝂₷
	AddRef();
	return S_OK;
}

ULONG CDictionary::AddRef() 
{
	// QƃJEg𑝂₷
	m_dwRef++;
    return m_dwRef; 
}

ULONG CDictionary::Release() 
{
	// QƃJEg炷
	m_dwRef--;
    if (m_dwRef == 0) 
    {
		// QƃJEg0̏ꍇCDictionaryIuWFNgj
        delete this; 
        return 0;
    }
    return m_dwRef;
}


HRESULT __stdcall CDictionary::LookupWord(char* lpszEword, char* lpszJword, BOOL* pbResult)
{
	for(int i=0; i<m_nWord; i++)
	{
		// pPƔr
		if(!strcmp(dic[i].Eword_dic, (char *)lpszEword))
		{
			// pPꂪꍇ
			strcpy(lpszJword, dic[i].Jword_dic);
			*pbResult = FOUND;
			return S_OK;
		}
	}
	// pPꂪȂꍇ
	strcpy(lpszJword, "[Not Found]");
	*pbResult = NotFOUND;
	return S_OK;
}



int main(int argc, char* argv[])
{
	
	return 0;
}

