import com.nttdocomo.ui.*;
import com.nttdocomo.io.*;
import com.nttdocomo.net.*;
import javax.microedition.io.*;
import java.io.*;
import java.util.*;

public class A extends MApplication implements KeyListener {
	public void keyPressed(Panel panel, int key) {
	}
	public void keyReleased(Panel panel, int key)	 {
		// ҂󂯃{^Ŕ񊈐ԁAxԂւ̑J
		if (key == Display.KEY_IAPP) {
			setWakeupTimer(INTERVAL * 1000); // INTERVALbɕA
			deactive = true;
			deactivate();
			sleep();
		}
	}
	boolean deactive = true; // 񊈐Ԃł邱ƂtO
	public void processSystemEvent(int type, int param) {
		if (type == FOLD_CHANGED_EVENT) {
			if (deactive) {
				// tbvCxg炷ɋxԂ
				sleep(); // ĂыxԂɈڍs
			}
		} else if (type == MODE_CHANGED_EVENT) {
			deactive = false;
		}
	}
	static final int INTERVAL = 10; // 10buɃT[oƒʐM
	// ------------------------------------------------------------------
	// f[^\
	// ------------------------------------------------------------------
	
	class Member {
		String name;
		String state;

		Member(String name, String state) {
			this.name = name;
			this.state = state;
		}
	}
	class Data {
		String myname = null;
		Vector member = new Vector();
		
		String[] getMemberNamesAndState() {
			String[] names = new String[member.size()];
			for (int i = 0; i < names.length; i++) {
				Member m = (Member)member.elementAt(i);
				names[i] = m.name + " [" + m.state + "]";
			}
			return names;
		}
		String[] getMemberNames() {
			String[] names = new String[member.size()];
			for (int i = 0; i < names.length; i++) {
				Member m = (Member)member.elementAt(i);
				names[i] = m.name;
			}
			return names;
		}
		int getMemberLength() {
			return member.size();
		}
	}
	Data data;

	class Message {
		String name;
		String message;

		Message(String name, String message) {
			this.name = name;
			this.message = message;
		}
	}
	
	// ------------------------------------------------------------------
	// f[^̉i
	// ------------------------------------------------------------------
	
	final int SP_DATA_POS = 0;
	void writeData(Data data) {
		try {
			OutputStream os = Connector.openOutputStream("scratchpad:///0;pos=" + SP_DATA_POS);
			writeString(os, data.myname);
			os.write(data.member.size());
			for (int i = 0; i < data.member.size(); i++) {
				Member member = (Member)data.member.elementAt(i);
				writeString(os, member.name);
				writeString(os, member.state);
			}
			os.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	void writeString(OutputStream os, String s) throws Exception {
		byte[] b = s.getBytes();
		os.write(b.length);
		os.write(b);
	}
	
	Data readData() {
		InputStream is = null;
		Data data = null;
		try {
			is = Connector.openInputStream("scratchpad:///0;pos=" + SP_DATA_POS);
			
			String myname = readString(is);
			if (myname != null) {
				data = new Data();
				data.myname = myname;
				int n = is.read();
				for (int i = 0; i < n; i++) {
					Member member = new Member(readString(is), readString(is));
					data.member.addElement(member);
				}
			}
			is.close();
		} catch (Exception e) {
			e.printStackTrace();
			try {
				if (is != null)
					is.close();
			} catch (Exception e2) {
			}
		}
		return data; // G[ɂnullԂ
	}
	String readString(InputStream is) throws Exception {
		int len = is.read();
		if (len == 0)
			return null;
		byte[] b = new byte[len];
		int off = 0;
		for (;;) {
			int n = is.read(b, off, len);
			if (n < 0)
				return null;
			off += n;
			len -= n;
			if (len == 0)
				break;
		}
		return new String(b);
	}
	
	// ------------------------------------------------------------------
	// T[oƂ̒ʐM
	// ------------------------------------------------------------------
	
	class Network {
		InputStream http(String name, String[] nameval) throws Exception {
			String res = null;
			HttpConnection conn = null;

			try {
				String url = IApplication.getCurrentApp().getSourceURL() + "servlet/BusinessIM/" + name;
				
				// p[^GR[h
				if (nameval.length > 0) {
					url += "?";
					for (int i = 0; i < nameval.length / 2; i++) {
						url += nameval[i * 2] + "=" + URLEncoder.encode(nameval[i * 2 + 1]) + "&";
					}
					url = url.substring(0, url.length() - 1);
				}
				System.out.println("access to: " + url);
				
				conn = (HttpConnection)Connector.open(url, Connector.READ);
				conn.setRequestMethod(HttpConnection.GET);
				
				conn.connect();
				
				InputStream in = conn.openInputStream();
				
				int len = (int)conn.getLength();
				
				// ǂݍ
				byte[] buf = new byte[len];
				int off = 0;
				for (;;) {
					int n = in.read(buf, off, len);
					if (n < 0)
						throw new Exception();
					off += n;
					len -= n;
					if (len == 0)
						break;
				}
				in.close();
				conn.close();
				return new ByteArrayInputStream(buf);
			} catch (Exception e) {
				try {
					if (conn != null)
						conn.close();
				} catch (Exception e2) {
				}
				throw e;
			}
		}
		boolean sendInit(String myname) { // ID󂯎
			try {
				InputStream is = http("sendInit", new String[] { "name", myname });
				boolean res = is.read() == 1;
				return res;
			} catch (Exception e) {
				e.printStackTrace();
			}
			return false;
		}
		Message[] update(Data data) { // I
			try {
				InputStream is = http("update", new String[] { "name", data.myname });
				
				// o[Ԃ̎擾
				int nmember = is.read();
				data.member.removeAllElements();
				for (int i = 0; i < nmember; i++) {
					String name = readString(is);
					String state = readString(is);
					Member member = new Member(name, state);
					data.member.addElement(member);
				}
				
				// bZ[W̎擾
				int nmes = is.read();
				Message[] message = new Message[nmes];
				for (int i = 0; i < nmes; i++) {
					String name = readString(is);
					String mes = readString(is);
					message[i] = new Message(name, mes);
				}
				
				return message;
			} catch (Exception e) {
				e.printStackTrace();
			}
			return new Message[0];
		}
		void sendState(String myname, String state) {
			try {
				http("sendState", new String[] { "name", myname, "state", state });
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		void sendMessage(String myname, String toname, String mes) {
			try {
				http("sendMessage", new String[] { "myname", myname, "toname", toname, "mes", mes });
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	Network network = new Network();
	
	// ------------------------------------------------------------------
	// epl̎
	// ------------------------------------------------------------------

	class InitPanel extends Panel implements SoftKeyListener {
		TextBox name;
		InitPanel() {
			setKeyListener(A.this);
			
			data = readData();
			if (data != null) {
				new StateViewPanel();
				return;
			}

			setTitle("o^");
			
			add(new Label("O"));
			name = new TextBox("", 20, 1, TextBox.DISPLAY_ANY);
			add(name);
			
			setSoftLabel(Frame.SOFT_KEY_1, "nj");
			setSoftKeyListener(this);
			Display.setCurrent(this);
		}
		public void softKeyPressed(int key) {
			if (key == Frame.SOFT_KEY_1) {
				String myname = name.getText();
				network.sendInit(myname);
				data = new Data();
				data.myname = myname;
				writeData(data);
				new StateViewPanel();
			}
		}
		public void softKeyReleased(int key) {
		}
	}

	class StateViewPanel extends Panel implements SoftKeyListener, Runnable {
		ListBox memberview;
		StateViewPanel() {
			setKeyListener(A.this);

			setTitle("rWlXhl");
			
			memberview = new ListBox(ListBox.SINGLE_SELECT, 9);
			memberview.setItems(data.getMemberNamesAndState());
			add(memberview);

			// \tgL[̃xݒ肵A\tgL[󂯎Lɂ
			setSoftLabel(Frame.SOFT_KEY_1, ""); // ԕύX
			setSoftLabel(Frame.SOFT_KEY_2, "M");  // bZ[WM
			setSoftKeyListener(this);
			Display.setCurrent(this);
			
			// 莞ԒuɍXVXbhN
			new Thread(this).start();
		}
		public void softKeyPressed(int key) {
			if (key == Frame.SOFT_KEY_1) { // ԕύX
				new ChangeStatePanel(this);
			} else if (key == Frame.SOFT_KEY_2) { // bZ[WM
				new SendMessagePanel(this);
			}
		}
		public void softKeyReleased(int key) {
		}
		
		// 莞ԒuɍXVXbh
		public void run() {
			for (;;) {
				if (Display.getCurrent() == this) {
					Message[] message = network.update(data); // dataXV
					writeData(data); // dataXNb`pbhɏo
					memberview.setItems(data.getMemberNamesAndState()); // dataʂɔf
					new ReceiveMessagePanel(this, message);
				}
				if (deactive) {
					setWakeupTimer(INTERVAL * 1000); // INTERVALbɕA
					try {
						sleep(); // 񊈐ԂȂĂыxԂɈڍs
					} catch (Exception e) {
					}
				}
				try {
					for (int i = 0; i < INTERVAL; i++) {
						if (deactive)
							break;
						Thread.sleep(1000); // 1b҂
					}
				} catch (Exception e) {
				}
			}
		}
	}

	class ChangeStatePanel extends Panel implements SoftKeyListener {
		Panel back;
		
		ListBox state;
		String[] STATE_LIST = { "d", "xe", "c", "Oo", "A" };
		ChangeStatePanel(Panel back) {
			setKeyListener(A.this);

			this.back = back;

			setTitle("ԕύX");
			
			add(new Label(""));
			state = new ListBox(ListBox.CHOICE);
			state.setItems(STATE_LIST);
			state.select(0);
			add(state);
			
			setSoftLabel(Frame.SOFT_KEY_1, "nj");
			setSoftLabel(Frame.SOFT_KEY_2, "~");
			setSoftKeyListener(this);
			Display.setCurrent(this);
		}
		public void softKeyPressed(int key) {
			if (key == Frame.SOFT_KEY_1) {
				String st = state.getItem(state.getSelectedIndex());
				network.sendState(data.myname, st);
			}
			Display.setCurrent(back);
		}
		public void softKeyReleased(int key) {
		}
	}
	
	class SendMessagePanel extends Panel implements SoftKeyListener {
		Panel back;
		
		ListBox to;
		ListBox mes;
		
		String[] MESSAGE_LIST = { "db", "[ǂ", "", "", "₾" };
		SendMessagePanel(Panel back) {
			setKeyListener(A.this);

			this.back = back;
			
			setTitle("bZ[WM");
			
			add(new Label(""));
			to = new ListBox(ListBox.CHOICE);
			String[] names = data.getMemberNames();
			if (names.length == 0) // o[OȂ牽I
				return;
			to.setItems(names);
			to.select(0);
			add(to);

			add(new Label("MbZ[W"));
			mes = new ListBox(ListBox.CHOICE);
			mes.setItems(MESSAGE_LIST);
			mes.select(0);
			add(mes);
			
			setSoftLabel(Frame.SOFT_KEY_1, "nj");
			setSoftLabel(Frame.SOFT_KEY_2, "~");
			setSoftKeyListener(this);
			Display.setCurrent(this);
		}
		
		public void softKeyPressed(int key) {
			if (key == Frame.SOFT_KEY_1) {
				String message = mes.getItem(mes.getSelectedIndex());
				String toname = to.getItem(to.getSelectedIndex());
				network.sendMessage(data.myname, toname, message);
			}
			Display.setCurrent(back);
		}
		public void softKeyReleased(int key) {
		}
	}

	class ReceiveMessagePanel extends Panel implements SoftKeyListener {
		Panel back;
		
		Message[] message;
		
		ReceiveMessagePanel(Panel back, Message[] message) {
			setKeyListener(A.this);

			this.back = back;
			this.message = message;
			if (message.length == 0)
				return;
			
			setTitle("bZ[WM");
			
			add(new Label(""));
			add(new TextBox(message[0].name, 20, 1, TextBox.DISPLAY_ANY));

			add(new Label("MbZ[W"));
			add(new TextBox(message[0].message, 20, 1, TextBox.DISPLAY_ANY));
			
			setSoftLabel(Frame.SOFT_KEY_1, "nj");
			setSoftKeyListener(this);
			Display.setCurrent(this);
		}
		
		public void softKeyPressed(int key) {
			if (key == Frame.SOFT_KEY_1) {
				if (message.length > 1) { // \ׂbZ[W
					Message[] m = new Message[message.length - 1];
					System.arraycopy(message, 1, m, 0, m.length);
					Display.setCurrent(new ReceiveMessagePanel(back, m));
				} else { // \ׂbZ[WȂΖ߂
					Display.setCurrent(back);
				}
			}
		}
		public void softKeyReleased(int key) {
		}
	}
	// ------------------------------------------------------------------
	// iAv̊Jn\bh
	// ------------------------------------------------------------------
	public void start() {
		new InitPanel();
	}
}
