import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;

public class BusinessIM extends HttpServlet {
	public void doGet(
		HttpServletRequest request, HttpServletResponse response
	) throws IOException, ServletException {
		String path = request.getPathInfo();
		
		DatabaseAccess da = new DatabaseAccess();
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		
		// ꂼ̏
		if (path.equals("/sendInit")) {
			sendInit(baos, request, da); // o^
		} else if (path.equals("/update")) {
			update(baos, request, da); // f[^XV
		} else if (path.equals("/sendState")) {
			sendState(baos, request, da); // ԍXV
		} else if (path.equals("/sendMessage")) {
			sendMessage(baos, request, da); // bZ[WM
		}
		
		byte[] res = baos.toByteArray();
		response.setContentType("application/octet-stream");
		response.setContentLength(res.length);
		OutputStream os = response.getOutputStream();
		os.write(res);
		os.close();
	}
	// ------------------------------------------------------------------
	static String decode(String s) throws IOException {
		return new String(s.getBytes("ISO8859_1"), "SJIS");
	}
	// ------------------------------------------------------------------
	void sendInit(OutputStream os, ServletRequest req, DatabaseAccess da) throws IOException {
		String name = decode(req.getParameter("name"));
		boolean res = false;
		if (name != null && name.length() > 0) {
			res = da.registUser(name);
		}
		os.write(res ? 1 : 0);
	}
	static void writeString(OutputStream os, String s) throws IOException {
		byte[] b = s.getBytes("SJIS");
		os.write(b.length);
		os.write(b);
	}
	void update(OutputStream os, ServletRequest req, DatabaseAccess da) throws IOException {
		String name = decode(req.getParameter("name"));
		String[][] state = da.getUserState();
		String[][] mes = da.getUserMessage(name);
		
		// o[̏ԑM
		os.write(state.length);
		for (int i = 0; i < state.length; i++) {
			writeString(os, state[i][0]);
			writeString(os, state[i][1]);
		}
		
		// bZ[WM
		os.write(mes.length);
		for (int i = 0; i < mes.length; i++) {
			writeString(os, mes[i][0]);
			writeString(os, mes[i][1]);
		}
	}
	void sendState(OutputStream os, ServletRequest req, DatabaseAccess da) throws IOException {
		String name = decode(req.getParameter("name"));
		String state = decode(req.getParameter("state"));
		da.changeUserState(name, state);
	}
	void sendMessage(OutputStream os, ServletRequest req, DatabaseAccess da) throws IOException {
		String myname = decode(req.getParameter("myname"));
		String toname = decode(req.getParameter("toname"));
		String mes = decode(req.getParameter("mes"));
		da.registMessage(myname, toname, mes);
	}
}
