import com.nttdocomo.ui.*;
import com.nttdocomo.device.Camera;
import java.io.*;
import java.util.Random;

public final class Card extends IApplication {
	
	public void start() {
		new C();
		C.main();
	}
}

class C extends Canvas {
	
    static final Image[] img = new Image[15];
	static final C _canvas = new C();
	
	static final Camera cam = Camera.getCamera(0);
	
	//  WFl[^
	static final Random ran = new Random();
	
	//萔Q
	static final int SCENE_INIT  = -1;
	static final int SCENE_TITLE = 0;
	static final int SCENE_GAME  = 1;
	static final int SCENE_DECK  = 2;
	static final int SCENE_DECK_VIEW   = 200;
	static final int SCENE_DECK_CAMERA = 201;
	static final int SCENE_DECK_EDIT   = 202;

	// ʐ^TCY 176~144	
	static final int PICTURE_WIDTH  = 176;
	static final int PICTURE_HEIGHT = 144;

		
	static int DECK_MENU_COUNT = 2;
	static int CARD_COUNT = 3;
	
	//ϐQ
	static int scene = -1;
	static int event = 0;
	
	static int picture_count = 0;
	
	static int cursolX = 0;
	static int cursolDeckMenu = 0;
	static int cursolDeck = 0;
	
	static int turn    = 0;
	static int selectP = -1;
	static int win,lose,draw;
	
	static int add;
	
	static int new_cp;
	
	static int[] stockP  = new int[3];
	static int[] stockE  = new int[3];
	static int[] status  = new int[6];
	
	static int[] card_pow = new int[6];
	
	static boolean battle = false;
	static boolean flg_picture;
	
	
	public C() {}
	
	static final void main() {
		Display.setCurrent(_canvas);
		
		try {
			for (int i=0;i<9;i++) {
				MediaImage mi = MediaManager.getImage("resource:///"+ i +".gif");
				mi.use();
				img[i] = mi.getImage();
			}
			
		} catch (IOException e) {
		}

		nextScene(SCENE_TITLE, "I", "ޯ");

		for (;;) {
			switch(scene) {
				case SCENE_TITLE:
					switch(event) {
						case Display.KEY_SELECT:
							stockP = cardSet(15);
							stockE = cardSet(15);
							turn = 1;
							
							nextScene(SCENE_GAME, "I", "");
							break;
						case Display.KEY_SOFT1:
							IApplication.getCurrentApp().terminate();
							break;
						case Display.KEY_SOFT2:
							nextScene(SCENE_DECK, "", "߂");
							break;
					}
					break;
				// SCENE_TITLE end
					
				case SCENE_GAME:
					add = 0;
					switch(event) {
						case Display.KEY_LEFT:
							add = CARD_COUNT - 1;
							break;
							
						case Display.KEY_RIGHT:
							add = 1;
							break;
							
						case Display.KEY_SELECT:
							if (turn == 4) {
								break;
							}
							if (!battle) {
								battle = true;
								if (status[cursolX] == 0) {
									if (stockP[cursolX] > stockE[turn-1]) {
										//
										status[cursolX] = 1;
										status[turn + 2] = 2;
										win++;
									} else if (stockP[cursolX] < stockE[turn-1]) {
										//
										status[cursolX] = 2;
										status[turn + 2] = 1;
										lose++;
									} else {
										//
										status[cursolX] = 3;
										status[turn + 2] = 3;
										draw++;
									}
									turn++;
									if (turn == 4) {
										_canvas.setSoftLabel(1, "");
									}
								}
							}
							break;
						
						case Display.KEY_SOFT1:
							IApplication.getCurrentApp().terminate();
							break;
							
						case Display.KEY_SOFT2:
							if (turn == 4) {
								cursolX = 0;
								turn    = 0;
								selectP = -1;
								win = lose = draw = 0;
								
								for (int i=0;i<3;i++) {
									stockP[i] = 0;
									stockE[i] = 0;
								}
								for (int i=0;i<6;i++) {
									status[i] = 0;
								}
								nextScene(SCENE_TITLE, "I", "ޯ");
							}
							break;
					}
					if (CARD_COUNT > 0) {
						cursolX += add;
						cursolX %= CARD_COUNT;
					}
					break;
				// SCENE_GAME end
								
				case SCENE_DECK:
					add = 0;
					switch (event) {
						case Display.KEY_UP:
							add = DECK_MENU_COUNT - 1;
							break;
						case Display.KEY_DOWN:
							add = 1;
							break;
						case Display.KEY_SELECT:
							switch (cursolDeckMenu) {
                                case 0:
                                    nextScene(SCENE_DECK_VIEW,   "߂", "");
                                    break;
								case 1:
									nextScene(SCENE_DECK_CAMERA, "߂", "ۑ");
									break;
                            }
							break;
						case Display.KEY_SOFT1:
                            // fbLZ[u
							
                        case Display.KEY_SOFT2:
							nextScene(SCENE_TITLE, "I", "ޯ");
                            break;
                    }
                    cursolDeckMenu += add;
					cursolDeckMenu %= DECK_MENU_COUNT;
					break;
				// SCENE_DECK end
				
				case SCENE_DECK_VIEW:
					switch (event) {
						case Display.KEY_LEFT:
                            if (cursolDeck > 0) {
                            	cursolDeck--;
                            }
							break;
						case Display.KEY_RIGHT:
                            if (cursolDeck < picture_count+8) {
                            	cursolDeck++;
                            }
							break;
						case Display.KEY_SOFT1:
							nextScene(SCENE_DECK, "", "߂");
							break;
                    }
					break;
				// SCENE_DECK_VIEW end
				
				case SCENE_DECK_EDIT:
					switch (event) {
						case Display.KEY_LEFT:
                            
							break;
						case Display.KEY_RIGHT:
                            
							break;
						case Display.KEY_SELECT:
                            
							break;
					}
					break;
				// SCENE_DECK_EDIT end
				
				case SCENE_DECK_CAMERA:
					switch (event) {
						case Display.KEY_SELECT:
                            if (!flg_picture) {
	                            try {
	                                cam.setImageSize(PICTURE_WIDTH, PICTURE_HEIGHT);
	                                cam.takePicture();
	                                if (cam.getNumberOfImages() == 0) {
	                                	//ʐ^BȂꍇ̏
	                                	break;
	                                }
	                                MediaImage mi = cam.getImage(0);
	                                mi.use();
	                                img[picture_count+9] = mi.getImage();
	                                flg_picture = true;
									repaint2();
									int rgb = _canvas.getGraphics().getRGBPixel(120, 120);
									int r = (rgb >> 4) & 0xFF;
									int g = (rgb >> 2) & 0xFF;
									int b =  rgb       & 0xFF;
									new_cp = r*g*b % 9 + 1;
	                            } catch (Exception e) {}
                            }
                            
							break;
						case Display.KEY_SOFT1:
							nextScene(SCENE_DECK, "", "߂");
							flg_picture = false;
							break;
						case Display.KEY_SOFT2:
							int[] pixs = _canvas.getGraphics().getPixels(
								(Display.getWidth()-50)/2,
								(Display.getHeight()-30)/2,
								50, 30, null, 0); 
							img[picture_count+9] = Image.createImage(50, 30, pixs, 0);
							card_pow[picture_count] = new_cp;
							picture_count++;
							nextScene(SCENE_DECK, "", "߂");
							flg_picture = false;
							break;
					}
					break;
				// SCENE_DECK_CAMERA end
			}
			event = 0;
			repaint2();
			if (battle) {
				battle = false;
			}
		}

	}
	
	static void repaint2() {
		_canvas.paint(_canvas.getGraphics());
	}
	
	public void paint(Graphics g) {
		synchronized (this) {
			g.lock();
	
			g.clearRect(0, 0, getWidth(), getHeight());
			g.setColor(0);
	
			switch(scene) {
				case SCENE_INIT:
					drawStringCenter(g, "Nc", 120);
					break;
				// SCENE_INIT end
				
				case SCENE_TITLE:
					drawStringCenter(g, "nl", 120);
					drawStringCenter(g, "{^Ă", 140);
					break;
				// SCENE_TITLE end
				
				case SCENE_GAME:
					g.fillRect(55+(cursolX*60), 195, 60, 40);
					
					if (turn == 4) {
						drawStringCenter(g, win+""+lose+"s"+draw+"", 140);
						drawStringCenter(g, "\tgL[2Ń^Cgɖ߂", 155);
					}
					
					if (battle) {
						g.drawImage(img[stockP[cursolX]-1], 120, 150);
						g.drawImage(img[stockE[turn-2]-1], 60, 70);
					}
					
					for (int i=0;i<3;i++) {
						//̃J[h\iEj
						g.drawImage(img[stockP[i]-1], 60+(i%3*60), 200);
						//G̃J[h\ij
						g.drawImage(img[stockE[i]-1], 10+(i%3*60), 20);
						
						//J[h̏s\
						if (status[i] == 1) {
							g.drawString("Win", 80+(i%3*60), 190);
						} else if (status[i] == 2) {
							g.drawString("Lose", 80+(i%3*60), 190);
						} else if (status[i] == 3) {
							g.drawString("Draw", 80+(i%3*60), 190);
						}
						if (status[i+3] == 1) {
							g.drawString("Win", 30+(i%3*60), 85);
						} else if (status[i+3] == 2) {
							g.drawString("Lose", 30+(i%3*60), 85);
						} else if (status[i+3] == 3) {
							g.drawString("Draw", 30+(i%3*60), 85);
						}
						
						//܂JĂȂG̃J[hhԂ
						if (turn-2 < i){
							g.fillRect(10+(i%3*60), 20, 50, 30);
						}
					}
					break;
				// SCENE_GAME end

				case SCENE_DECK:
					drawStringCenter(g, "J[hXe[V", 25);
					drawStringCenter(g, "J[h̊mF", 60);
					//drawStringCenter(g, "fbL̕ҏW", 80);
					drawStringCenter(g, "JŃJ[h", 80);
					g.drawRect(20, 45 + cursolDeckMenu * 20, getWidth() - 40, 18);
					break;
				// SCENE_DECK end
				
				case SCENE_DECK_VIEW:
					drawStringCenter(g, "J[h{[h", 25);
					if (cursolDeck == 0) {
						g.drawImage(img[0], 95, 100);
						g.drawImage(img[1], 160, 100);
						g.drawString("", 220, 120);
					} else if (cursolDeck == picture_count+8) {
						g.drawImage(img[picture_count+7], 30, 100);
						g.drawImage(img[picture_count+8], 95, 100);
						g.drawString("", 10, 120);
					} else {
						for (int i=0;i<3;i++) {
							g.drawImage(img[cursolDeck-1+i], 30+65*i, 100);
						}
						g.drawString("", 10, 120);
						g.drawString("", 220, 120);
					}
					if (cursolDeck < 9) {
						drawStringCenter(g, ": "+(cursolDeck+1), 160);
					} else {
						drawStringCenter(g, ": "+(card_pow[cursolDeck-9]), 160);
					}
					break;
				// SCENE_DECK_VIEW end
				
				case SCENE_DECK_EDIT:
					drawStringCenter(g, "fbLҏW[h", 25);
					break;
				// SCENE_DECK_EDIT end
				
				case SCENE_DECK_CAMERA:
					drawStringCenter(g, "J[hWFl[^", 25);
					if (flg_picture) {
						drawStringCenter(g, "Be摜", 45);
						g.drawImage(img[picture_count+9],
									(getWidth()-PICTURE_WIDTH)/2,
									(getHeight()-PICTURE_HEIGHT)/2);
						g.setColor(g.getColorOfName(g.WHITE));
						g.drawRect((getWidth()-52)/2, (getHeight()-32)/2, 52, 32);
						g.drawRect((getWidth()-54)/2, (getHeight()-34)/2, 54, 34);
						g.setColor(0);
						drawStringCenter(g, ": "+new_cp, 200);
					} else {
						drawStringCenter(g, "{^ĎBeĂ", 45);
					}
					
					break;
				// SCENE_DECK_CAMERA end
			}
	
			g.unlock(true);
		}
	}
	
	/*
	 * L[/ƁA
	 * processEventĂ΂
	 * 
	 * L[ꂽɂ́ADisplay.KEY_PRESSED_EVENTA
	 * L[ꂽɂ́ADisplay.KEY_RELEASED_EVENT
	 * paramɑ
	 */
	public void processEvent(int param, int key) {
		if (param == Display.KEY_PRESSED_EVENT) {
			event = key;
		}
	}
	
	/**
	 * cardSet
	 * 3̍vl傤ǈ̒lɂȂ悤
	 * _3̐lԂ
	 * @param  3̍vl
	 * @return _3̐lizj
	 */
	private static int[] cardSet(int max) {
		int[] array = new int[3];
		array[0] = ranRange(1, 9);
		int start = max-9-array[0];
		int end   = max-1-array[0];
		if (start < 1) {
			start = 1;
		}
		if (end > 9) {
			end = 9;
		}
		array[1] = ranRange(start, end);
		array[2] = max - array[0] - array[1];
		return array;
	}
	
	/**
	 * ranRange
	 * startend܂ł̊Ԃ̗Ԃ
	 * 
	 * @param  start ŏl
	 * @param  end   ől
	 * @return l
	 */
	private static int ranRange(int start, int end) {
		int retrand;
		int range  = (end - start) + 1;
		do {
			retrand = Math.abs(ran.nextInt() % range);
		} while (retrand == 0);
		return retrand + start -1;
	}
	
	/**
	 * nextScene
	 * ̃V[ɑJڂA\tgL[xݒ肷B
	 * 
	 * @param  nextscene	̃V[
	 * @param  soft1	\tgL[P̃x
	 * @param  soft2	\tgL[Q̃x
	 */
	private static void nextScene(int nextscene, String soft1, String soft2) {
		_canvas.setSoftLabel(0, soft1);
		_canvas.setSoftLabel(1, soft2);
		scene = nextscene;
	}

	/**
	 * drawStringCenter
	 * XgOw肵̉ʒɕ\
	 * 
	 * @param  g	OtBbNIuWFNg
	 * @param  str	\镶
	 * @param  h	\
	 */
	private void drawStringCenter(Graphics g, String str, int h) {
		g.drawString(str, 
		  (getWidth() - Font.getDefaultFont().stringWidth(str)) / 2, h);
	}

}