<?php
    
    DEFINE("DUEL_TABLE_NAME","duel");
    require_once('DBAccess.php');
    
class duelDBA extends DBAccess{
    /**
    * @access private
    */
    var $_db;
    var $_table;

    /**
    *   󥹥ȥ饯
    *   ĤǤ³
    */
    function duelDBA($dsn)
    {
        $this->_table = DUEL_TABLE_NAME;
        $this->_db = $this->_connect($dsn);
    }
    
    //duelơ֥˿ɲ
    //ɲä줿duel_id֤
    function insertNewDuel($user_id)
    {
        $res = $this->lock($this->_table, "WRITE");
        if(PEAR::isError($res)){
            return 0;
        }
        $duel_id = $this->_nextDuelID();
        $sql = "INSERT INTO $this->_table (duel_id , user_id) 
                        VALUES($duel_id , $user_id)";
        $res = $this->_db->query($sql);
        if(PEAR::isError($res)){
            $this->commit();
            return 0;
        }
        $this->commit();
        return $duel_id;
    }
    
    //ꤷduel_id˿ɲ
    function insertDuel($user_id, $duel_id)
    {
        $sql = "INSERT INTO $this->_table (duel_id , user_id) 
                        VALUES($duel_id , $user_id)";
        $res = $this->_db->query($sql);
        if(PEAR::isError($res)){
            return false;
        }
        return true;
    }
    
    //duelID
    function _nextDuelID()
    {
        $sql = "SELECT MAX(duel_id) FROM $this->_table ";
        $res = $this->_db->query($sql);
        if(PEAR::isError($res)){
            return 0;
        }
        $row = $res->fetchRow();
        $new_id = $row[0] + 1;
        return $new_id;
    }
    
    //ͤ򹹿
    function updateCardValue($user_id, $card, $duel_id)
    {
        $sql = "UPDATE $this->_table 
                    SET card = $card,
                        turn = turn + 1
                    WHERE   duel_id = $duel_id
                        AND user_id = $user_id
               ";
        $res = $this->_db->query($sql);
        if(PEAR::isError($res)){
            return false;
        }
        return true;
    }
    
    //ߤΥֹ
    function selectNowTurn($user_id, $duel_id)
    {
        $sql = "SELECT turn FROM $this->_table 
                    WHERE user_id = $user_id 
                      ANd duel_id = $duel_id
               ";
        $res = $this->_db->query($sql);
        if(PEAR::isError($res)){
            return PEAR::raiseError('DB ERROR');
        }
        $row= $res->fetchRow();
        return $row[0];
    }
    
    //Υͤ
    function selectHisCardValue($my_id, $duel_id, $turn)
    {
        $sql = "SELECT card FROM $this->_table 
                    WHERE   user_id != $my_id 
                        ANd duel_id = $duel_id 
                        AND turn    = $turn
               ";
        $res = $this->_db->query($sql);
        if(PEAR::isError($res)){
            return PEAR::raiseError('DB ERROR');
        }
        if(!$res->numRows()){
            return -1;
        }
        $row= $res->fetchRow();
        return $row[0];
    }
    
    //ID
    function selectHisUserId($my_id, $duel_id)
    {
        $sql = "SELECT user_id FROM $this->_table 
                    WHERE   user_id != $my_id 
                        ANd duel_id = $duel_id 
               ";
        $res = $this->_db->query($sql);
        if(PEAR::isError($res)){
            return PEAR::raiseError('DB ERROR');
        }
        if(!$res->numRows()){
            return PEAR::raiseError('NO USER');
        }
        $row= $res->fetchRow();
        return $row[0];
    }
    
    //ꤷuser_idϿ줿ľduel_id
    function selectLatestDuelID($user_id)
    {
        $sql = "SELECT duel_id FROM $this->_table 
                    WHERE user_id = $user_id 
                    ORDER BY duel_id DESC
               ";
        $res = $this->_db->query($sql);
        if(PEAR::isError($res)){
            return PEAR::raiseError('DB ERROR');
        }
        if(!$res->numRows()){
            return PEAR::raiseError('NO_ID');
        }
        $row= $res->fetchRow();
        return $row[0];
    }
    
    //ֹ򹹿
    function updateTurn($duel_id, $turn)
    {
        $sql = "UPDATE $this->_table 
                    SET turn = $turn 
                    WHERE duel_id = $duel_id
               ";
        $res = $this->_db->query($sql);
        if(PEAR::isError($res)){
            return false;
        }
        return true;
    }
}
?>
