<?php
/**
*   @package cards
*   @author MasakiTakegami <m_takegami@spicysoft.com>
*/

require_once('dba/userDBA.php');
/**
*   񤭤ADFե
*/
define(JAM_FILE_PATH, "Card.jam");


/**
*   Downloadɬפʵǽ򽸤᤿饹
*   @package cards
*   @author MasakiTakegami <m_takegami@spicysoft.com>
*/
class Download{
    
    /**
    *   i⡼ɤUTN°
    *
    *   1) DoCoMo/1.0/X503i/c10/ser*********** 
    *   -> ser***********
    *   2) DoCoMo/2.0 YYYY(c10;serXXXXXXXXXXXXXXX; iccxxxxxxxxxxxxxxxxxxxx) 
    *   -> serXXXXXXXXXXXXXXX; iccxxxxxxxxxxxxxxxxxxxx
    *
    *   @param  string $ua 桼
    *   @return string $utn UTN
    */
    function getUtn($ua)
    {
        $utn = "";
        if (!$ua || strlen($ua) == 0) {
            return "";
        }
        //ɽUTNʬڤ
        //  50x꡼
        if (preg_match('/^DoCoMo\/1.0/i',$ua)) {
            if (preg_match("/(ser[A-Za-z0-9]{11})$/i",$ua,$matches)) {
                $utn = $matches[1];
            }
        } elseif (preg_match('/^DoCoMo\/2.0/i',$ua)) {
        //  FOMA꡼
            if (preg_match("/\;(ser[A-Za-z0-9]{15}\;icc[A-Za-z0-9]{20})\)$/i",$ua,$matches)) {
                $utn = $matches[1];
            }
        }

        return $utn;
    }
    
    /**
    *   桼Ͽ
    *
    *   @param  string $user_name 桼̾
    *   @param  string $utn       UTN
    *   @see DownloadDBA
    */
    function registUser($user_name,$utn)
    {
        $dao = new UserDBA(DSN);
        $dao->lock(USER_TABLE_NAME, "WRITE");
        $user_id = (int)$dao->getUserIdFromUtn($utn);

        //顼λPEARERROR饹Υ֥ȤƤФ
        if(PEAR::isError($user_id)){
            $dao->commit();
            return PEAR::raiseError();
        }
        
        if($user_id > 0){
            $res = $dao->updateUserName($user_id, $user_name);
            if(PEAR::isError($res)){
                $dao->commit();
                return PEAR::raiseError();
            }
        }else{
            $user_id = $dao->insertNewUser(
                                       $utn, 
                                       $user_name
                                       );
            if(PEAR::isError($user_id)){
                $dao->commit();
                return PEAR::raiseError();
            }
        }
        $dao->commit();
        return $user_id;
    }
    
    /**
    *   ADFեUTN
    *
    *   @param   int    $user_id  桼ID
    *   @return  string $jam      ADFե
    */
    function writeJam($utn)
    {
        $file_path = JAM_FILE_PATH;
        //ե򳫤
        $fp = fopen($file_path, 'r');
        $jam = fread($fp, 10240);
        fclose($fp);
        $jam  = ereg_replace('{UTN}', $utn, $jam);
        
        return $jam;
    }

    /**
    *   顼Ϥ
    *
    *   @param   string    $message  顼å
    *   @return  void
    */
    function showError($message)
    {
        $error = "<html><body>
        $message<br>
        ⤦ϤƤ</a>
        <a href=\"./download.htm\"></a>
        </body></html>";
        $error = mb_convert_encoding($error,"SJIS","EUC-JP");
        echo $error;
        exit;
        }
}
?>
