<?php
/**
*@package cards
*@author m_takegami@spicysoft.com
*/

define("TURN_GAME_OVER", 4);
require_once("dba/DBObjectManager.php");

class Duel{
    var $_my_id;
    var $_duel_id;
    var $_dbm;
    
    function Duel($user_id)
    {
        $this->_my_id = $user_id;
        $this->_dbm = new DuelDBObjectManager();
    }

    //ᥤ
    function attack($card)
    {
        //duel_id
        $res = $this->_setDuelID();
        if(PEAR::isError($res)){
            return $res;
        }
        
        //ʬΥͤ򥢥åץǡȤ
        $turn = $this->_myAttack($card);
        if(PEAR::isError($turn)){
            return $turn;
        }

        //Υͤ
        $card = $this->_fetchHisCardValue($turn);
        
        //꤬ޤɤФƤʤ硢Ԥ
        if($card == -1){
            $card = $this->_wait($turn);
        }
        
        return $card;
    }
    
    //duel_id򥻥å
    function _setDuelID()
    {
        $dba = $this->_dbm->getDAO(DUEL_DAO);
        $res = $dba->selectLatestDuelID($this->_my_id);
        if(PEAR::isError($res)){
            return $res;
        }
        $this->_duel_id = $res;
        return true;
    }
    
    //Υͤ
    function _fetchHisCardValue($turn)
    {
        assert($turn);
        $dba = $this->_dbm->getDAO(DUEL_DAO);
        $res = $dba->selectHisCardValue($this->_my_id, $this->_duel_id, $turn);
        if(PEAR::isError($res)){
            return -1;
        }
        return $res;
    }
    
    //Ե֤
    function _wait($turn)
    {
        $i = 0;
        while(1){
            $result = $this->_fetchHisCardValue($turn);
             if(PEAR::isError($result)){
                return $result;
            }
            if($result > -1){
                //ͤǤХ롼פȴ
                return  $result;
            }elseif($i > 12){
                //ॢȻˤ"-1"֤
                return  -1;
            }
         sleep(1);
         $i++;
        }

    }
    
    //ʬΥͤ򹹿
    //ͤϥֹ
    function _myAttack($card)
    {
        $dba = $this->_dbm->getDAO(DUEL_DAO);
        $res = $dba->updateCardValue($this->_my_id, $card, $this->_duel_id);
        if(PEAR::isError($res)){
            return $res;
        }
        $res = $dba->selectNowTurn($this->_my_id, $this->_duel_id);
        if(PEAR::isError($res)){
            return $res;
        }
        return $res;
    }

    //Ӥ򹹿
    function finalize($my_result)
    {

        $this->_setDuelID();
        if(PEAR::isError($res)){
            return PEAR::raiseError();
        }
        
        //ཪλԤƤ뤫ǧ
        if($this->_hasAlreadyFinalized()){
            //Ƥｪλ
            return;
        }

        //ཪλ
        if(!$this->_processGameOver($my_result)){
            return PEAR::raiseError();
        }
        return;
    }
    
    //Ǥ˽λԤƤ뤫ǧ
    function _hasAlreadyFinalized()
    {
        $dba  = $this->_dbm->getDAO(DUEL_DAO);
        $turn = $dba->selectNowTurn($this->_my_id, $this->_duel_id);
        if(PEAR::isError($turn)){
            return false;
        }
        
        if($turn < TURN_GAME_OVER){
            return false;
        }

        return true;
    }
    
    //λԤ
    function _processGameOver($my_result)
    {
        $dba  = $this->_dbm->getDAO(DUEL_DAO);
        //duelơ֥򹹿
        if(!$dba->updateTurn($this->_duel_id, TURN_GAME_OVER)){
            return false;
        }
        
        $his_id = $dba->selectHisUserId($this->_my_id, $this->_duel_id);
        if(PEAR::isError($his_id)){
            return false;
        }

        $dba  = $this->_dbm->getDAO(USER_DAO);
        //ʬӤ򥢥åץǡ
        if(!$dba->updateDuelScore($this->_my_id, $my_result)){
            return false;
        }
    
        $his_result = $this->_getHisResult($my_result);
        
        //Ӥ򥢥åץǡ
        if(!$dba->updateDuelScore($his_id, $his_result)){
            return false;
        }
        return true;
    }

    //ʬη̤顢η̤
    function _getHisResult($my_result)
    {
        switch($my_result){
            case  RESULT_WIN :
                return RESULT_LOSE;
            case RESULT_DRAW :
                return RESULT_DRAW;
            case  RESULT_LOSE :
                return RESULT_WIN;
            default:
                assert(0);
        }
    }
}
?>