<?php

require_once("dba/DBObjectManager.php");
require_once("duelistList.php");
require_once("duel.php");

define("ACTION_SEARCH", 0);
define("ACTION_ATTACK", 1);
define("ACTION_RESULT", 2);
define("ACTION_ERROR",  3);

class DuelActionController{
    function open($request)
    {
        //ѥ᡼
        $action = $this->getValueFromArray($request, 'action', ACTION_ERROR);
        $utn    = $this->getValueFromArray($request, 'utn', '');
        if(!$utn){
            $this->_respondError();
        }
        
        //user_id
        $dbm = new DuelDBObjectManager();
        $dba    = $dbm->getDAO(USER_DAO);
        $user_id = $dba->getUserIdFromUtn($utn);
        if(PEAR::isError($result)){
            $this->_respondError();
        }
        
        //
        switch($action){
            //긡
            case ACTION_SEARCH:
                $list   = new DuelistList($user_id);
                $result = $list->search();
                break;
            //Хȥ
            case ACTION_ATTACK:
                $card   = $this->getValueFromArray($request, 'card', 1);
                $duel   = new Duel($user_id);
                $result = $duel->attack($card);
                break;
            //ཪλ
            case ACTION_RESULT:
                $res   = $this->getValueFromArray($request, 'res', 2);
                $duel   = new Duel($user_id);
                $result = $duel->finalize($res);
                break;
            default:
                $this->_respondError();
        }
        if(PEAR::isError($result)){
            $this->_respondError();
        }
        
        //饤Ȥ᤹
        $this->_respond($result);
    }
    
    //饤Ȥ᤹ͤ
    function _respond($data)
    {
        $msg = "1";
        if(!is_array($data)){
            if(!is_null($data)){
                $msg .= "/$data";
            }
        }else{
            foreach($data as $value){
                $msg .= "/" . urlencode($value);
            }
        }
        

        print $msg;
        exit;
    }
    
    //饤Ȥ˥顼᤹
    function _respondError()
    {
        print "0";
        exit;
    }
    
    //󤫤ͤ
    //PHPξ¸ߤʤ˥褦ȤȡNOTICEФ
    function getValueFromArray($array, $key, $default = "")
    {
        if(isset($array) && isset($array[$key])){
            return $array[$key];
        }
        return $default;
    }
}
?>
