<?php
/**
*@package cards
*@author m_takegami@spicysoft.com
*/

require_once("dba/DBObjectManager.php");

/**
*@package cards
*/
class DuelistList{
    var $_my_id;
    var $_dbm;
    
    function DuelistList($user_id)
    {
        $this->_my_id = $user_id;
        $this->_dbm = new DuelDBObjectManager();
    }
    
    function _tablelock()
    {
        $dba    = $this->_dbm->getDAO(WAITING_DAO);
        $res = $dba->waitingLock();
        if(PEAR::isError($res)){
            simpleLOG::trace("LOCK ERROR");
        }
    }
    function _unlock()
    {
        $dba    = $this->_dbm->getDAO(WAITING_DAO);
        $dba->commit();
    }
    
    //򸡽Ф
    function search()
    {
        //Թ
        $res = $this->_initWaitingStat();
        if(PEAR::isError($res)){
            return $res;
        }
        
        $this->_tablelock();
        $user_id = $this->_existsDuelist();
        if(PEAR::isError($user_id)){
            $this->_unlock();
            return $user_id;
        }
        
        if($user_id){
            if(!$this->_challenge($user_id)){
                $this->_unlock();
                return PEAR::raiseError('SYSTEM_ERROR');
            }
            $this->_unlock();
        }else{
            $this->_unlock();
            //10ô֥롼פʤԤ³
            $duel_id = $this->_wait();
            //Թ
            $this->_initWaitingStat();
            if(PEAR::isError($duel_id)){
                return $duel_id;
            }
            if(!$this->_adDuel($duel_id)){
                return PEAR::raiseError('filed adDuel');
            }
            $user_id = $this->_getUserIdOfChallenger($duel_id);
        }
        
        return  $this->_respondHisData($user_id);
    }
    
    //ơ֥˼ʬΥǡɲ
    function _adDuel($duel_id)
    {
        $dba = $this->_dbm->getDAO(DUEL_DAO);
        if(!$dba->insertDuel($this->_my_id, $duel_id)){
            return false;
        }
        return true;
    }
    
    //Ե꤬뤫Ĵ٤
    function _existsDuelist()
    {
        $dba    = $this->_dbm->getDAO(WAITING_DAO);
        $user_id = $dba->selectOneWaitingDuelist();
        if(PEAR::isError($result)){
            return $result;
        }
        return $user_id;
    }
    
    //
    function _initWaitingStat()
    {
        $dba    = $this->_dbm->getDAO(WAITING_DAO);
        //ʬԵ
        $dba->deleteWaitingStat($this->_my_id);
        if(PEAR::isError($result)){
            return $result;
        }
        return ture;
    }
    //ĩԤΥ桼ID
    function _getUserIdOfChallenger($duel_id)
    {
        $dba = $this->_dbm->getDAO(DUEL_DAO);
        $user_id = $dba->selectHisUserId($this->_my_id, $duel_id);
        return $user_id;
    }
    
    //Ե
    function _wait(){
        $i = 0;
        $dba = $this->_dbm->getDAO(WAITING_DAO);
        if(!$dba->insertWaitingStat($this->_my_id)){
            return PEAR::raiseError('DB_ERROR:INSERTWAITINGSTAT');
        }
        while(1){
             $result = $dba->selectWaitingStat($this->_my_id);
             if(PEAR::isError($result)){
                return $result;
             }
             if($result){
                return  $result;
             }elseif($i > 9){
                return  PEAR::raiseError('TIMEOUT');
             }
             sleep(1);
             $i++;
        }
    }
    
    //̾
    function _challenge($his_id)
    {
        $battle_id = $this->_createNewDuel($his_id);
        if(!$battle_id){
            return false;
        }
        if(!$this->_informHim($his_id, $battle_id)){
            return false;
        }
        return true;
    }
    
    //Ӥ᤹
    function _respondHisData($user_id)
    {
        $dba  = $this->_dbm->getDAO(USER_DAO);
        $res  = $dba->selectDuelData($user_id);
        if(PEAR::isError($res)){
            return false;
        }
        return $res;
    }
    
    //duelơ֥˿ɲä
    function _createNewDuel()
    {
        $dba   = $this->_dbm->getDAO(DUEL_DAO);
        return $dba->insertNewDuel($this->_my_id);
    }
    
    //waitingơ֥򹹿ơΤ
    function _informHim($his_id, $battle_id)
    {
        $dba   = $this->_dbm->getDAO(WAITING_DAO);
        $res = $dba->updateBattleID($battle_id, $his_id);
        return $res;
    }
}
?>