import com.nttdocomo.ui.*;
import com.nttdocomo.io.*;
import com.nttdocomo.net.URLDecoder;
import com.nttdocomo.util.Timer;
import com.nttdocomo.util.TimerListener;
import com.nttdocomo.device.Camera;

import java.io.*;
import java.util.Random;

import javax.microedition.io.Connector;

public final class Card extends IApplication {
    
    public void start() {
        new C();
        C.main();
    }
}

class C extends Canvas implements TimerListener {
    
    static final IApplication IApp = IApplication.getCurrentApp();
    static final C _canvas = new C();
    
    static final Camera cam = Camera.getCamera(0);
    
    static Timer timerSess  = new Timer();
    static Timer timerCount = new Timer();
    
    //  WFl[^
    static final Random ran = new Random();
    
    //萔Q
    static final int SCENE_INIT  = -1;
    static final int SCENE_TITLE = 0;
    static final int SCENE_GAME  = 1;
    static final int SCENE_DECK  = 2;
    //static final int SCENE_DECK_VIEW   = 200;
    static final int SCENE_DECK_CAMERA = 201;
    static final int SCENE_DECK_EDIT   = 202;
    
    static final String SP_POS = "scratchpad:///0;pos=";
    static final int SP_FIRST_FLG  = 0;
    static final int SP_DECK_CARD  = 1;
    static final int SP_CARD_FLG   = 4;
    static final int SP_PL_HISTRY  = 76;
    static final int SP_IMAGE_SIZE = 88;
    static final int SP_IMAGE_DATA = 200;

    // ʐ^TCY 176~144  
    static final int PICTURE_WIDTH  = 176;
    static final int PICTURE_HEIGHT = 144;
    
    static final int RES_COUNT = 5;
    static final int MAX_CARD_COUNT = 72;

    static final int DECK_MENU_COUNT = 2;
    
    static final int CARD_COUNT = 3;
    
    //ϐQ
    static int scene = -1;
    static int event = 0;
    
    static int pictureCount;
    
    static int cursolX = 0;
    static int cursolTitle = 0;
    static int cursolDeckMenu = 0;
    static int cursolDeck = 0;
    
    static String nameP;
    static String nameE;
        
    static int turn    = 0;
    static int selectP = -1;
    static int selectE = -1;
    static int winP, loseP, drawP;
    
    static int limitCount;
    
    static int[] playerHist = new int[3];
    static int[] enemyHist  = new int[3];
    
    static String utnP = IApp.getArgs()[0];
    
    static String strNet;
    
    static int add;
    
    static int newCardNum;
    
    static int deckCount = 0;
    static int[] stockBuf = {-1,-1,-1}; 
    
    static int[] stockP  = new int[CARD_COUNT];
    static int[] stockE  = new int[CARD_COUNT];
    static int[] status  = new int[CARD_COUNT*2];
    
    static int[] keepCard = new int[MAX_CARD_COUNT];
    
    static int[] imageSize = new int[RES_COUNT];
    
    static Image[] img = new Image[RES_COUNT];
    static Image imgCamera;
    
    static int  flgFirst = 0;  
    static boolean battle = false;
    static boolean flgPicture = false;
    static boolean flgMatch = false;
    static boolean flgNetBattle = false;
    
    static InputStream is = null;
    static DataInputStream dis = null;
    static OutputStream os = null;
    static DataOutputStream dos = null;
    static HttpConnection hc = null;
    
    static final int[] cardPow = {
            1,2,3,4,5,1,2,3,4,5,6,7,
            1,2,3,4,5,6,7,8,9,1,2,3,
            4,5,6,7,8,9,10,11,1,2,3,4,
            5,6,7,8,9,10,11,12,13,1,2,3,
            4,5,6,7,8,9,10,11,12,13,14,15,
            9,10,11,12,13,14,15,16,17,18,19,20
    };

    static final int[] cardRare = {
            1,1,1,1,1,1,1,1,1,1,2,2,
            1,1,1,1,1,2,2,2,3,1,1,1,
            1,1,2,2,2,3,3,3,1,1,1,2,
            2,2,3,3,3,4,4,4,4,1,1,1,
            2,2,2,3,3,3,4,4,4,4,5,5,
            4,4,4,4,5,5,5,5,5,6,6,6
    };
    static final String[] cardName = {
            "AKX","AX^g","AXf","A~B","AhDVAX","A",
            "AZ","AhX","AhAtX","Ah}EX","C|X","E@",
            "GS[","IZ","IAX","IoX","JC","J[V",
            "K~W","K[v","NP","OC\","S[","TuibN",
            "TIX","UK","Vg[","VCX","VNX","XgX",
            "ZG","[p[","__A","fJrA","ixEX","nQeB",
            "n{","npX","oA","oV","o","oogX",
            "pC","rtX","tFlNX","tHX","tHlEX","tEX",
            "tJX","tJX","tt","uG","uHtH","u[l",
            "v\","xA","xX","xg","{[eBX","}NX",
            "}RLAX","}oX","}t@X","[[","E","[W",
            "mEF","@bTS","@v","BlA","Fp","HN"
    };
    
    public C() {
    }
    
    static final void main() {
        Display.setCurrent(_canvas);
        
        //timerSess.setTime(1000);      //debug
        timerSess.setTime(25000);       //release
        timerSess.setRepeat(false);
        timerSess.setListener(_canvas);
        
        timerCount.setTime(1000);
        timerCount.setRepeat(true);
        timerCount.setListener(_canvas);
        
        try {
            is = Connector.openInputStream(SP_POS + SP_FIRST_FLG);
            flgFirst = is.read();
            is.close();
            int image_pos = 0;
            if (flgFirst == 0) {
                byte[] byteData;
                for(int i=0;i<RES_COUNT;i++) {
                    hc = (HttpConnection)Connector.open(
                            IApp.getSourceURL() + "res/card" + i + ".gif",
                            Connector.READ, true);
                    hc.setRequestMethod(HttpConnection.GET);
                    hc.connect();
                    imageSize[i] = (int)hc.getLength();
                    is = hc.openInputStream();
                    byteData = new byte[imageSize[i]];
                    is.read(byteData);
                    is.close();
                    hc.close();
                    
                    dos = Connector.openDataOutputStream(SP_POS + (SP_IMAGE_SIZE+i*4));
                    dos.writeInt(imageSize[i]);
                    dos.close();
                    
                    os = Connector.openOutputStream(SP_POS + (SP_IMAGE_DATA+image_pos));
                    os.write(byteData);
                    os.close();
                    
                    image_pos += imageSize[i];
                }
                
                os = Connector.openOutputStream(SP_POS + SP_DECK_CARD);
                for (int i=0;i<CARD_COUNT;i++) {
                    stockP[i] = i;
                    os.write(i);
                }
                for (int i=0;i<5;i++) {
                    keepCard[i] = 1;
                    os.write(1);
                }
                os.close();
                
                //f[^̃_E[hƕۑɐNtO𗧂Ă
                os = Connector.openOutputStream(SP_POS + SP_FIRST_FLG);
                os.write(1);
                os.close();
                
            } else {
                is = Connector.openInputStream(SP_POS + SP_DECK_CARD);
                for (int i=0;i<CARD_COUNT;i++) {
                    stockP[i] = is.read();
                }
                pictureCount = 0;
                for (int i=0;i<MAX_CARD_COUNT;i++) {
                    keepCard[i] = is.read();
                    pictureCount += keepCard[i];
                }
                is.close();
                dis = Connector.openDataInputStream(SP_POS + SP_PL_HISTRY);
                for (int i=0;i<CARD_COUNT;i++) {
                    playerHist[i] = dis.readInt();
                }
                for (int i=0;i<RES_COUNT;i++) {
                    imageSize[i] = dis.readInt();
                }
                dis.close();
            }
            image_pos = 0;
            for (int i=0;i<RES_COUNT;i++) {
                MediaImage mi = MediaManager.getImage(SP_POS + (SP_IMAGE_DATA+image_pos));
                mi.use();
                img[i] = mi.getImage();
                image_pos += imageSize[i];
            }
        } catch (IOException e) {
            System.out.println("s\n");
            System.out.println("E:"+e);
            ConnectionException ce = (ConnectionException)e;
            System.out.println("Status:"+ce.getStatus());

        }

        nextScene(SCENE_TITLE, "I", "ޯ");

        for (;;) {
            switch(scene) {
                case SCENE_TITLE:
                    switch(event) {
                        case Display.KEY_SELECT:
                            if (cursolTitle == 0) {
                                stockE = cardSet(15);
                                turn = 1;
                                nextScene(SCENE_GAME, "I", "");
                            } else if (cursolTitle == 1) {
                                flgMatch = true;
                                showDialog("ΐ푊܂", Dialog.DIALOG_INFO);
                                try {
                                    hc = connectPost();
                                    sendPost("action=0&utn=" + utnP);
                                    timerSess.stop();
                                    timerSess.start();
                                    hc.connect();
                                    
                                    if (!flgMatch) {
                                        throw new Exception();
                                    }
                                    strNet = receivePost();
                                    hc.close();
                                    timerSess.stop();
                                    System.out.println("strNet:"+strNet);
                                    if (strNet.startsWith("0")) {
                                        throw new Exception();
                                    }
                                    
                                    int start = 2, end = strNet.indexOf("/", 2);
                                    nameE = strNet.substring(start, end);
                                    nameE = URLDecoder.decode(nameE);
                                    System.out.println("nameE:"+nameE+","+start+","+end);
                                    
                                    
                                    for (int i=0;i<3;i++) {
                                        start = end+1;
                                        end = strNet.indexOf("/", start);
                                        if (end < 0) {
                                            end = strNet.length();
                                        }
                                        enemyHist[i] = Integer.parseInt(strNet.substring(start, end));
                                    }
                                    turn = 1;
                                    nextScene(SCENE_GAME, "I", "");
                                    flgMatch = false;
                                    flgNetBattle = true;
                                    timerCount.start();
                                    limitCount = 10;

                                } catch (Exception e) {
                                    //strNet = "ERROR";
                                    timerSess.stop();
                                    showDialog("ΐ푊肪ȂA" +
                                            "\nʐMɎs܂B", Dialog.DIALOG_ERROR);
                                    System.out.println("ex:"+e);
                                }
                                
                            }

                            break;
                        case Display.KEY_UP:
                        case Display.KEY_DOWN:
                            if (cursolTitle == 0) {
                                cursolTitle = 1;
                            } else if (cursolTitle == 1) {
                                cursolTitle = 0;
                            }
                            break;
                        case Display.KEY_SOFT1:
                            IApp.terminate();
                            break;
                        case Display.KEY_SOFT2:
                            nextScene(SCENE_DECK, "", "߂");
                            break;
                    }
                    break;
                // SCENE_TITLE end
                    
                case SCENE_GAME:
                    add = 0;
                    switch(event) {
                        case Display.KEY_LEFT:
                            add = CARD_COUNT - 1;
                            break;
                            
                        case Display.KEY_RIGHT:
                            add = 1;
                            break;
                            
                        case Display.KEY_SELECT:
                            if (turn >= 4) {
                                break;
                            }
                            if (!battle) {
                                battle = true;
                                if (status[cursolX] == 0) {
                                    if (flgNetBattle) {
                                        flgMatch = true;
                                        timerCount.stop();
                                        try {
                                            hc = connectPost();
                                            sendPost("action=1&utn="+utnP+"&card="+stockP[cursolX]);
                                            timerSess.stop();
                                            timerSess.start();
                                            hc.connect();
                                            
                                            if (!flgMatch) {
                                                throw new Exception();
                                            }
                                            strNet = receivePost();
                                            hc.close();
                                            timerSess.stop();
                                            System.out.println("strNet:"+strNet);
                                            if (strNet.startsWith("0")) {
                                                throw new Exception();
                                            }

                                            stockE[turn-1] = Integer.parseInt(strNet.substring(2));
                                            System.out.println("stockE[turn-1] = " + stockE[turn-1]);
                                            if (stockE[turn-1] == -1) {
                                            	
                                                stockE[turn-1] = 0;
                                                System.out.println("stockE[turn-1] = " + stockE[turn-1]);
                                                turn = 5;
                                                //flgNetBattle = false;
                                            }
                                        } catch (Exception e) {
                                            turn = 4;
                                            flgNetBattle = false;
                                            timerSess.stop();
                                            showDialog("ΐ풆FʐMɎs܂B", Dialog.DIALOG_ERROR);
                                            System.out.println("ex:"+e);
                                        }
                                        limitCount = 10;
                                        timerCount.stop();
                                        timerCount.start();
                                    }
                                    
                                    if (turn != 5) {
	                                    if (cardPow[stockP[cursolX]] > cardPow[stockE[turn-1]]) {
	                                        //
	                                        status[cursolX] = 1;
	                                        status[turn + 2] = 2;
	                                        winP++;
	                                    } else if (cardPow[stockP[cursolX]] < cardPow[stockE[turn-1]]) {
	                                        //
	                                        status[cursolX] = 2;
	                                        status[turn + 2] = 1;
	                                        loseP++;
	                                    } else {
	                                        //
	                                        status[cursolX] = 3;
	                                        status[turn + 2] = 3;
	                                        drawP++;
	                                    }
                                    }
                                    turn++;
                                    if (turn == 4 || turn == 6) {
                                        _canvas.setSoftLabel(1, "");
                                        timerCount.stop();
                                        int res = -1;
                                        if (winP - loseP > 0 || turn == 6) {
                                            //
                                            playerHist[0]++;
                                            res = 1;
                                        } else if (winP - loseP == 0) {
                                            //
                                            playerHist[2]++;
                                            res = 0;
                                        } else if (winP - loseP < 0) {
                                            //sk
                                            playerHist[1]++;
                                            res = 2;
                                        }
                                        if (flgNetBattle) {
	                                        try {
	                                            hc = connectPost();
	                                            sendPost("action=2&utn="+utnP+"&res="+res);
	                                            if (turn == 6) {
	                                            	showDialog("Ԑ؂ꏟ̒ʐMJn",Dialog.DIALOG_INFO);
	                                            }
	                                            timerSess.stop();
	                                            timerSess.start();
	                                            hc.connect();
	                                            if (!flgMatch) {
	                                                throw new Exception();
	                                            }
	                                            strNet = receivePost();
	                                            hc.close();
	                                            timerSess.stop();
	                                            System.out.println("strNet:"+strNet);
	                                            if (strNet.startsWith("0")) {
	                                                throw new Exception();
	                                            }
	                                        } catch (Exception e) {
	                                            turn = 5;
	                                            showDialog("ʑMFʐMɎs܂B", Dialog.DIALOG_ERROR);
	                                            System.out.println("ex:"+e);
	                                        } finally {
	                                        	flgNetBattle = false;
	                                        }
                                        }
                                        try {
                                            dos = Connector.openDataOutputStream(SP_POS + SP_PL_HISTRY);
                                            for (int i=0;i<3;i++) {
                                                dos.writeInt(playerHist[i]);
                                            }
                                            dos.close();
                                        } catch (IOException e) {
                                        	
                                        }
                                    }
                                }
                            }
                            break;
                        
                        case Display.KEY_SOFT1:
                            IApp.terminate();
                            break;
                            
                        case Display.KEY_SOFT2:
                            if (turn >= 4) {
                                cursolX = 0;
                                turn    = 0;
                                selectP = -1;
                                winP = loseP = drawP = 0;
                                limitCount = 10;
                                
                                for (int i=0;i<6;i++) {
                                    status[i] = 0;
                                }
                                nextScene(SCENE_TITLE, "I", "ޯ");
                            }
                            break;
                    }
                    if (CARD_COUNT > 0) {
                        cursolX += add;
                        cursolX %= CARD_COUNT;
                    }
                    break;
                // SCENE_GAME end
                
                case SCENE_DECK:
                    add = 0;
                    switch (event) {
                        case Display.KEY_UP:
                            add = DECK_MENU_COUNT - 1;
                            break;
                        case Display.KEY_DOWN:
                            add = 1;
                            break;
                        case Display.KEY_SELECT:
                            switch (cursolDeckMenu) {
                                case 0:
                                    nextScene(SCENE_DECK_EDIT,   "߂", "");
                                    break;
                                case 1:
                                    nextScene(SCENE_DECK_CAMERA, "߂", "ۑ");
                                    break;
                                
                            }
                            break;
                        case Display.KEY_SOFT1:
                            // fbLZ[u
                            
                        case Display.KEY_SOFT2:
                            nextScene(SCENE_TITLE, "I", "ޯ");
                            break;
                    }
                    cursolDeckMenu += add;
                    cursolDeckMenu %= DECK_MENU_COUNT;
                    break;
                // SCENE_DECK end
                
                case SCENE_DECK_EDIT:
                    add = 0;
                    switch (event) {
                        case Display.KEY_LEFT:
                            add = MAX_CARD_COUNT - 1;
                            break;
                        case Display.KEY_RIGHT:
                            add = 1;
                            break;
                        case Display.KEY_UP:
                            add = MAX_CARD_COUNT - 3;
                            break;
                        case Display.KEY_DOWN:
                            add = 3;
                            break;
                        case Display.KEY_SELECT:
                            if (deckCount <= 2) {
                                boolean flgLap = true;
                                for (int i=0;i<deckCount;i++) {
                                    if (stockBuf[i] == cursolDeck) {
                                        flgLap = false;
                                    }
                                }
                                if (flgLap && keepCard[cursolDeck] == 1) {
                                    stockBuf[deckCount] = cursolDeck;
                                    deckCount++;
                                }
                            } else if (deckCount == 3) {
                                try {
                                    os = Connector.openOutputStream(SP_POS + SP_DECK_CARD);
                                    for (int i=0;i<CARD_COUNT;i++) {
                                        stockP[i] = stockBuf[i];
                                        os.write(stockP[i]);
                                        stockBuf[i] = -1;
                                    }
                                    os.close();
                                } catch (IOException e) {
                                }
                                deckCount = 0;
                            }
                            break;
                        case Display.KEY_SOFT1:
                            nextScene(SCENE_DECK, "", "߂");
                            break;
                    }
                    cursolDeck += add;
                    cursolDeck %= MAX_CARD_COUNT;
                    break;
                // SCENE_DECK_EDIT end
                
                case SCENE_DECK_CAMERA:
                    switch (event) {
                        case Display.KEY_SELECT:
                            if (!flgPicture) {
                                try {
                                    cam.setImageSize(PICTURE_WIDTH, PICTURE_HEIGHT);
                                    cam.takePicture();
                                    if (cam.getNumberOfImages() == 0) {
                                        //ʐ^BȂꍇ̏
                                        break;
                                    }
                                    MediaImage mi = cam.getImage(0);
                                    mi.use();
                                    imgCamera = mi.getImage();
                                    flgPicture = true;
                                    repaint2();
                                    int rgb = _canvas.getGraphics().getRGBPixel(120, 120);
                                    int red = (rgb >> 4) & 0xFF;
                                    int grn = (rgb >> 2) & 0xFF;
                                    int blu =  rgb       & 0xFF;
                                    int divide = (red*4+grn*2+blu*3) % 100;
                                    if (divide < 50) {
                                        newCardNum = (red+grn+blu) % 30;
                                    } else if (divide < 80) {
                                        newCardNum = (red+grn+blu) % 60;
                                    } else if (divide < 90) {
                                        newCardNum = (red+grn+blu) % 72;
                                    }
                                    
                                } catch (Exception e) {}
                            }
                            break;
                        case Display.KEY_SOFT2: //VKJ[ho^Ė߂
                            if (flgPicture && keepCard[newCardNum] == 0) {
                                pictureCount++;
                                keepCard[newCardNum] = 1;
                                try {
                                    os = Connector.openOutputStream(SP_POS + (SP_CARD_FLG+newCardNum));
                                    os.write(1);
                                    os.close();
                                } catch (IOException e) {
                                }
                            }
                        case Display.KEY_SOFT1: //o^ɖ߂
                            nextScene(SCENE_DECK, "", "߂");
                            flgPicture = false;
                            newCardNum = 0;
                            break;
                    }
                    break;
                // SCENE_DECK_CAMERA end
                
            }
            event = 0;
            repaint2();
            if (battle) {
                battle = false;
            }
        }
    }
    
    static void repaint2() {
        _canvas.paint(_canvas.getGraphics());
    }
    
    public void paint(Graphics g) {
        synchronized (this) {
            g.lock();
    
            g.clearRect(0, 0, getWidth(), getHeight());
            g.setColor(0);
    
            switch(scene) {
                case SCENE_INIT:
                    drawStringCenter(g, "Nc", 120);
                    break;
                // SCENE_INIT end
                
                case SCENE_TITLE:
                    drawStringCenter(g, "\", 80);
                    drawStringCenter(g, "Rs[^ΐ", 110);
                    drawStringCenter(g, "lbg[Nΐ", 130);
                    drawStringCenter(g, "{^Ă", 160);
                    g.drawRect(20, 95 + cursolTitle * 20, getWidth() - 40, 18);
                    break;
                // SCENE_TITLE end
                
                case SCENE_GAME:
                    
                    if (turn == 4) {
                        drawStringCenter(g, playerHist[0]+""+
                                playerHist[1]+"s"+playerHist[2]+"", 115);
                        drawStringCenter(g, "\tgL[2Ń^Cgɖ߂", 130);
                    } else if (turn == 5) {
                        drawStringCenter(g, "ʐMQ̂", 115);
                        drawStringCenter(g, "͖ł", 130);
                    } else if (turn == 6) {
                        drawStringCenter(g, playerHist[0]+""+
                                playerHist[1]+"s"+playerHist[2]+"", 113);
                        drawStringCenter(g, "肪Ԑ؂ŏ", 127);
                        drawStringCenter(g, "\tgL[2Ń^Cgɖ߂", 141);
                    } else if (turn == 7) {
                        drawStringCenter(g, playerHist[0]+""+
                                playerHist[1]+"s"+playerHist[2]+"", 113);
                        drawStringCenter(g, "Ԑ؂Ŕsk", 127);
                        drawStringCenter(g, "\tgL[2Ń^Cgɖ߂", 141);
                    } else {
                        if (flgNetBattle) {
                            drawStringCenter(g, "ΐ푊F"+nameE, 115);
                            drawStringCenter(g, enemyHist[0]+""+
                                    enemyHist[1]+"s"+enemyHist[2]+"", 130);
                            for (int i=0;i<limitCount;i++) {
                                g.drawString("",30+i*15,145);
                            }
                        }
                    }
                    
                    for (int i=0;i<3;i++) {
                        //G̃J[h\ij
                        drawImageCard(g, stockE[i], 10+(i*60), 0);
                        //̃J[h\iEj
                        drawImageCard(g, stockP[i], 60+(i*60), 145);
                        
                        g.setColor(g.getColorOfName(g.WHITE));
                        
                        g.drawString(""+cardPow[stockP[i]], 68+(i*60), 163);
                        g.drawString(""+cardPow[stockE[i]], 18+(i*60), 83);
                        
                        //J[h̏s\
                        if (status[i] == 1) {
                            g.drawString("Win",  80+(i*60), 165);
                        } else if (status[i] == 2) {
                            g.drawString("Lose", 80+(i*60), 165);
                        } else if (status[i] == 3) {
                            g.drawString("Draw", 80+(i*60), 165);
                        }
                        if (status[i+3] == 1) {
                            g.drawString("Win",  30+(i*60), 85);
                        } else if (status[i+3] == 2) {
                            g.drawString("Lose", 30+(i*60), 85);
                        } else if (status[i+3] == 3) {
                            g.drawString("Draw", 30+(i*60), 85);
                        }
                        g.setColor(0);
                        
                        //܂JĂȂG̃J[hhԂ
                        if (turn-2 < i){
                            g.drawImage(img[1], 10+(i*60), 0);
                        }
                    }
                    //J[\
                    g.drawImage(img[4], 80+(cursolX*60), 205);
                    
                    break;
                // SCENE_GAME end

                case SCENE_DECK:
                    drawStringCenter(g, "J[hXe[V", 25);
                    drawStringCenter(g, "fbL̕ҏW", 60);
                    drawStringCenter(g, "JŃJ[h", 80);
                    g.drawRect(20, 45 + cursolDeckMenu * 20, getWidth() - 40, 18);
                    break;
                // SCENE_DECK end
                
                case SCENE_DECK_EDIT:
                    
                    drawStringCenter(g, "fbLҏW[h", 25);
                    if (cursolDeck == 0) {
                        drawImageCard(g, 0,  95, 60);
                        drawImageCard(g, 1, 160, 60);
                    } else if (cursolDeck == MAX_CARD_COUNT-1) {
                        drawImageCard(g, cursolDeck-1, 30, 60);
                        drawImageCard(g, cursolDeck,   95, 60);
                        if (keepCard[cursolDeck-1] == 0) {
                            g.drawImage(img[1], 30, 60);
                        }
                        if (keepCard[cursolDeck] == 0) {
                            g.drawImage(img[1], 95, 60);
                        }
                    } else {
                        for (int i=0;i<3;i++) {
                            drawImageCard(g, cursolDeck-1+i, 30+65*i, 60);
                            if (keepCard[cursolDeck-1+i] == 0) {
                                g.drawImage(img[1], 30+65*i, 60);
                            }
                        }
                    }
                    
                    g.drawString("fbL", 10, 170);
                    g.drawString("VfbL", 175, 170);
                    for (int i=0;i<CARD_COUNT;i++) {
                        if (stockBuf[i] >= 0) {
                            g.drawString(""+(i+1)+": "+(stockBuf[i]+1), 180, 185+i*15);
                        } else {
                            g.drawString(""+(i+1)+": ", 180, 185+i*15);
                        }
                        g.drawString((i+1)+": "+(stockP[i]+1), 15, 185+i*15);
                    }
                    
                    g.drawString("", 10, 120);
                    g.drawString("", 220, 120);
                    drawStringCenter(g, "y[W߂", 45);
                    drawStringCenter(g, "y[W聫", 230);
                    
                    if (keepCard[cursolDeck] == 0) {
                        drawStringCenter(g, "No."+(cursolDeck+1), 175);
                        drawStringCenter(g, "XXXXXXX", 190);
                        drawStringCenter(g, ": unknown", 205);
                    } else {
                        drawStringCenter(g, "No."+(cursolDeck+1), 175);
                        drawStringCenter(g, cardName[cursolDeck], 190);
                        drawStringCenter(g, ": "+cardPow[cursolDeck], 205);
                        g.drawString("AeB: ", 60, 220);
                        for (int i=0;i<cardRare[cursolDeck];i++) {
                            g.drawString("", 132+i*12, 220);
                        }
                    }
                    break;
                // SCENE_DECK_EDIT end
                
                case SCENE_DECK_CAMERA:
                    drawStringCenter(g, "J[hWFl[^", 25);
                    if (flgPicture) {
                        drawStringCenter(g, "Be摜", 45);
                        g.drawImage(imgCamera,
                                    (getWidth()-PICTURE_WIDTH)/2,
                                    (getHeight()-PICTURE_HEIGHT)/2);
                        drawStringCenter(g, "No."+(newCardNum+1)+": "+
                                cardName[newCardNum]+" 𐶐I", 230);
                        //drawStringCenter(g, "No."+(new_cp+1)+" 𐶐I", 200);
                    } else {
                        drawStringCenter(g, "{^ĎBeĂ", 45);
                    }
                    
                    break;
                // SCENE_DECK_CAMERA end
            }
    
            g.unlock(true);
        }
    }
    
    /*
     * L[/ƁA
     * processEventĂ΂
     * 
     * L[ꂽɂ́ADisplay.KEY_PRESSED_EVENTA
     * L[ꂽɂ́ADisplay.KEY_RELEASED_EVENT
     * paramɑ
     */
    public void processEvent(int param, int key) {
        if (param == Display.KEY_PRESSED_EVENT) {
            event = key;
        }
    }
    
    /*
     * TimerŐݒ肵Ԃo߂ƃR[Cxg
     * @see com.nttdocomo.util.TimerListener#timerExpired(com.nttdocomo.util.Timer)
     */
    public void timerExpired(Timer t) {
        if (t == timerSess) {
            if(flgMatch) {
                try {
                    is.close();
                    hc.close();
                } catch (IOException e) {}
                flgMatch = false;
            }
        }
        if (t == timerCount) {
            if (flgNetBattle) {
                limitCount--;
                if (limitCount <= 0) {
                    timerCount.stop();
                    _canvas.setSoftLabel(1, "");
                    turn = 7;
                    flgNetBattle = false;
                    playerHist[1]++;
                    try {
                        dos = Connector.openDataOutputStream(SP_POS + (SP_PL_HISTRY+4));
                        dos.writeInt(playerHist[1]);
                        dos.close();
                    } catch (IOException e) {}
                }
            }
        }
    }
    
    /**
     * cardSet
     * 3̍vl傤ǈ̒lɂȂ悤
     * _3̐lԂ
     * @param  3̍vl
     * @return _3̐lizj
     */
    private static int[] cardSet(int max) {
        int[] array = new int[3];
        array[0] = ranRange(1, 9);
        int start = max-9-array[0];
        int end   = max-1-array[0];
        if (start < 1) {
            start = 1;
        }
        if (end > 9) {
            end = 9;
        }
        array[1] = ranRange(start, end);
        array[2] = max - array[0] - array[1];
        return array;
    }
    
    /**
     * ranRange
     * startend܂ł̊Ԃ̗Ԃ
     * 
     * @param  start ŏl
     * @param  end   ől
     * @return l
     */
    private static int ranRange(int start, int end) {
        int retrand;
        int range  = (end - start) + 1;
        do {
            retrand = Math.abs(ran.nextInt() % range);
        } while (retrand == 0);
        return retrand + start -1;
    }
    
    /**
     * nextScene
     * ̃V[ɑJڂA\tgL[xݒ肷B
     * 
     * @param  nextscene    ̃V[
     * @param  soft1    \tgL[P̃x
     * @param  soft2    \tgL[Q̃x
     */
    private static void nextScene(int nextscene, String soft1, String soft2) {
        _canvas.setSoftLabel(0, soft1);
        _canvas.setSoftLabel(1, soft2);
        scene = nextscene;
    }

    /**
     * drawStringCenter
     * XgOw肵̉ʒɕ\
     * 
     * @param  g    OtBbNIuWFNg
     * @param  str  \镶
     * @param  h    \
     */
    private void drawStringCenter(Graphics g, String str, int h) {
        g.drawString(str, 
          (getWidth() - Font.getDefaultFont().stringWidth(str)) / 2, h);
    }
    
    /**
     * drawImageCard
     * w肵ԍ̃J[hꗗ摜̒甲oĕ`
     * 
     * @param  g    OtBbNIuWFNg
     * @param  card \J[h
     * @param  dx   \XW
     * @param  dy   \YW
     */
    private void drawImageCard(Graphics g, int card, int dx, int dy) {
        if (card < 0 || 71 < card) {
            return;
        }
        g.drawImage(img[0], dx, dy);
        //g.drawImage(img[2], dx+7, dy+30, (card%12)*32, (card/12)*32, 32, 32);
        if (card < 32) {
        	g.drawImage(img[2], dx+7, dy+30, (card%6)*32, (card/6)*32, 32, 32);
        } else {
        	g.drawImage(img[3], dx+7, dy+30, (card%6)*32, ((card-MAX_CARD_COUNT/2)/6)*32, 32, 32);
        }
    }

    /**
     * showDialog
     * ȈՃ_CAON\bh
     * 
     * @param  msg      _CAOɕ\镶
     * @param  type     _CAO̎ނw
     * @return [UI
     */
    private static int showDialog(String msg, int type) {
        Dialog d = new Dialog(type, "infomation");
        d.setText(msg);
        return d.show();
    }

    /**
     * connectPost
     * XNvgւ̐ڑ\bh
     * 
     * @return HttpConnection
     */
    private static HttpConnection connectPost() {
        try {
            hc = (HttpConnection)Connector.open(
                    IApp.getSourceURL() + "arena.php",
                    Connector.READ_WRITE, true);
            hc.setRequestMethod(HttpConnection.POST);
            hc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        } catch (IOException e) {}
        return hc;
    }

    /**
     * sendPost
     * ڑĂXNvgɃf[^𑗐M
     * 
     * @param sendData Mf[^
     */
    private static boolean sendPost(String sendData) {
        try {
            os = hc.openOutputStream();
            byte[] outdata = sendData.getBytes();
            os.write(outdata);
            System.out.println("sendData: "+sendData);
            os.close();
            return true;
        } catch (IOException e) {
            return false;
        }
    }

    /**
     * receivePost
     * ڑĂXNvgf[^M
     * 
     * @return Mf[^
     */
    private static String receivePost() {
        try {
            is = hc.openInputStream();
            int isbuf;
            byte[] single = new byte[1];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for(;;) {
                if((isbuf = is.read(single)) < 0) {
                    break;
                }
                baos.write(single);
            }
            is.close();
            return baos.toString();
        } catch (IOException e) {
            return null;
        }
    }

}